/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.approximate;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.opensearch.search.approximate.ApproximateQuery;
import org.opensearch.search.internal.SearchContext;

public final class ApproximateScoreQuery
extends Query {
    private final Query originalQuery;
    private final ApproximateQuery approximationQuery;
    Query resolvedQuery;

    public ApproximateScoreQuery(Query originalQuery, ApproximateQuery approximationQuery) {
        this.originalQuery = originalQuery;
        this.approximationQuery = approximationQuery;
    }

    public Query getOriginalQuery() {
        return this.originalQuery;
    }

    public ApproximateQuery getApproximationQuery() {
        return this.approximationQuery;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.resolvedQuery == null) {
            return this.originalQuery.rewrite(indexSearcher);
        }
        return this.resolvedQuery.rewrite(indexSearcher);
    }

    public void setContext(SearchContext context) {
        if (this.resolvedQuery != null) {
            throw new IllegalStateException("Query already resolved, duplicate call to setContext");
        }
        this.resolvedQuery = this.approximationQuery.canApproximate(context) ? this.approximationQuery : this.originalQuery;
    }

    public String toString(String s) {
        return "ApproximateScoreQuery(originalQuery=" + this.originalQuery.toString() + ", approximationQuery=" + this.approximationQuery.toString() + ")";
    }

    public void visit(QueryVisitor queryVisitor) {
        QueryVisitor v = queryVisitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this);
        this.originalQuery.visit(v);
        this.approximationQuery.visit(v);
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.originalQuery.hashCode();
        h = 31 * h + this.approximationQuery.hashCode();
        return h;
    }
}

