/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Helper;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;

final class PointTreeTraversal {
    private static final Logger logger = LogManager.getLogger((String)Helper.loggerName);

    private PointTreeTraversal() {
    }

    static FilterRewriteOptimizationContext.DebugInfo multiRangesTraverse(PointValues.PointTree tree, Ranges ranges, BiConsumer<Integer, Integer> incrementDocCount, int maxNumNonZeroRanges) throws IOException {
        FilterRewriteOptimizationContext.DebugInfo debugInfo = new FilterRewriteOptimizationContext.DebugInfo();
        int activeIndex = ranges.firstRangeIndex(tree.getMinPackedValue(), tree.getMaxPackedValue());
        if (activeIndex < 0) {
            logger.debug("No ranges match the query, skip the fast filter optimization");
            return debugInfo;
        }
        RangeCollectorForPointTree collector = new RangeCollectorForPointTree(incrementDocCount, maxNumNonZeroRanges, ranges, activeIndex);
        PointValues.IntersectVisitor visitor = PointTreeTraversal.getIntersectVisitor(collector);
        try {
            PointTreeTraversal.intersectWithRanges(visitor, tree, collector, debugInfo);
        }
        catch (CollectionTerminatedException e) {
            logger.debug("Early terminate since no more range to collect");
        }
        collector.finalizePreviousRange();
        return debugInfo;
    }

    private static void intersectWithRanges(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, RangeCollectorForPointTree collector, FilterRewriteOptimizationContext.DebugInfo debug) throws IOException {
        PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r) {
            case CELL_INSIDE_QUERY: {
                collector.countNode((int)pointTree.size());
                debug.visitInner();
                break;
            }
            case CELL_CROSSES_QUERY: {
                if (pointTree.moveToChild()) {
                    do {
                        PointTreeTraversal.intersectWithRanges(visitor, pointTree, collector, debug);
                    } while (pointTree.moveToSibling());
                    pointTree.moveToParent();
                    break;
                }
                pointTree.visitDocValues(visitor);
                debug.visitLeaf();
                break;
            }
        }
    }

    private static PointValues.IntersectVisitor getIntersectVisitor(final RangeCollectorForPointTree collector) {
        return new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                throw new UnsupportedOperationException("This IntersectVisitor does not perform any actions on a docID=" + docID + " node being visited");
            }

            public void visit(int docID, byte[] packedValue) throws IOException {
                this.visitPoints(packedValue, (CheckedRunnable<IOException>)((CheckedRunnable)collector::count));
            }

            public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                this.visitPoints(packedValue, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
                    int doc = iterator.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        collector.count();
                        doc = iterator.nextDoc();
                    }
                }));
            }

            private void visitPoints(byte[] packedValue, CheckedRunnable<IOException> collect) throws IOException {
                if (!collector.withinUpperBound(packedValue)) {
                    collector.finalizePreviousRange();
                    if (collector.iterateRangeEnd(packedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (collector.withinRange(packedValue)) {
                    collect.run();
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (!collector.withinUpperBound(minPackedValue)) {
                    collector.finalizePreviousRange();
                    if (collector.iterateRangeEnd(minPackedValue)) {
                        throw new CollectionTerminatedException();
                    }
                }
                if (!collector.withinLowerBound(maxPackedValue)) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (collector.withinRange(minPackedValue) && collector.withinRange(maxPackedValue)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        };
    }

    private static class RangeCollectorForPointTree {
        private final BiConsumer<Integer, Integer> incrementRangeDocCount;
        private int counter = 0;
        private final Ranges ranges;
        private int activeIndex;
        private int visitedRange = 0;
        private final int maxNumNonZeroRange;

        public RangeCollectorForPointTree(BiConsumer<Integer, Integer> incrementRangeDocCount, int maxNumNonZeroRange, Ranges ranges, int activeIndex) {
            this.incrementRangeDocCount = incrementRangeDocCount;
            this.maxNumNonZeroRange = maxNumNonZeroRange;
            this.ranges = ranges;
            this.activeIndex = activeIndex;
        }

        private void count() {
            ++this.counter;
        }

        private void countNode(int count) {
            this.counter += count;
        }

        private void finalizePreviousRange() {
            if (this.counter > 0) {
                this.incrementRangeDocCount.accept(this.activeIndex, this.counter);
                this.counter = 0;
            }
        }

        private boolean iterateRangeEnd(byte[] value) {
            while (!this.withinUpperBound(value)) {
                if (++this.activeIndex < this.ranges.size) continue;
                return true;
            }
            ++this.visitedRange;
            return this.visitedRange > this.maxNumNonZeroRange;
        }

        private boolean withinLowerBound(byte[] value) {
            return Ranges.withinLowerBound(value, this.ranges.lowers[this.activeIndex]);
        }

        private boolean withinUpperBound(byte[] value) {
            return Ranges.withinUpperBound(value, this.ranges.uppers[this.activeIndex]);
        }

        private boolean withinRange(byte[] value) {
            return this.withinLowerBound(value) && this.withinUpperBound(value);
        }
    }
}

