/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.internal.SearchContext;

public abstract class AggregatorBridge {
    MappedFieldType fieldType;
    Consumer<Ranges> setRanges;

    void setRangesConsumer(Consumer<Ranges> setRanges) {
        this.setRanges = setRanges;
    }

    protected abstract boolean canOptimize();

    protected abstract void prepare() throws IOException;

    abstract Ranges tryBuildRangesFromSegment(LeafReaderContext var1) throws IOException;

    abstract FilterRewriteOptimizationContext.DebugInfo tryOptimize(PointValues var1, BiConsumer<Long, Long> var2, Ranges var3) throws IOException;

    public static boolean segmentMatchAll(SearchContext ctx, LeafReaderContext leafCtx) throws IOException {
        Weight weight = ctx.query().rewrite((IndexSearcher)ctx.searcher()).createWeight((IndexSearcher)ctx.searcher(), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        return weight != null && weight.count(leafCtx) == leafCtx.reader().numDocs();
    }
}

