/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.RoaringDocIdSet;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.IndexSortConfig;
import org.opensearch.lucene.queries.SearchAfterSortedDocQuery;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.composite.CompositeKey;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.opensearch.search.aggregations.bucket.filterrewrite.CompositeAggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.DateHistogramAggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.searchafter.SearchAfterBuilder;
import org.opensearch.search.sort.SortAndFormats;

public final class CompositeAggregator
extends BucketsAggregator {
    private final int size;
    private final List<String> sourceNames;
    private final int[] reverseMuls;
    private final MissingOrder[] missingOrders;
    private final List<DocValueFormat> formats;
    private final CompositeKey rawAfterKey;
    private final CompositeValuesSourceConfig[] sourceConfigs;
    private final SingleDimensionValuesSource<?>[] sources;
    private final CompositeValuesCollectorQueue queue;
    private final List<Entry> entries = new ArrayList<Entry>();
    private LeafReaderContext currentLeaf;
    private RoaringDocIdSet.Builder docIdSetBuilder;
    private BucketCollector deferredCollectors;
    private boolean earlyTerminated;
    private final FilterRewriteOptimizationContext filterRewriteOptimizationContext;
    private LongKeyedBucketOrds bucketOrds;

    CompositeAggregator(String name, AggregatorFactories factories, final SearchContext context, Aggregator parent, Map<String, Object> metadata, final int size, final CompositeValuesSourceConfig[] sourceConfigs, final CompositeKey rawAfterKey) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.size = size;
        this.sourceNames = Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::name).collect(Collectors.toList());
        this.reverseMuls = Arrays.stream(sourceConfigs).mapToInt(CompositeValuesSourceConfig::reverseMul).toArray();
        this.missingOrders = (MissingOrder[])Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::missingOrder).toArray(MissingOrder[]::new);
        this.formats = Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::format).collect(Collectors.toList());
        this.sources = new SingleDimensionValuesSource[sourceConfigs.length];
        int bucketLimit = context.aggregations().multiBucketConsumer().getLimit();
        if (size > bucketLimit) {
            throw new MultiBucketConsumerService.TooManyBucketsException("Trying to create too many buckets. Must be less than or equal to: [" + bucketLimit + "] but was [" + size + "]. This limit can be set by changing the [" + MultiBucketConsumerService.MAX_BUCKET_SETTING.getKey() + "] cluster level setting.", bucketLimit);
        }
        this.sourceConfigs = sourceConfigs;
        for (int i = 0; i < sourceConfigs.length; ++i) {
            this.sources[i] = sourceConfigs[i].createValuesSource(context.bigArrays(), context.searcher().getIndexReader(), size, x$0 -> this.addRequestCircuitBreakerBytes(x$0));
        }
        this.queue = new CompositeValuesCollectorQueue(context.bigArrays(), this.sources, size, rawAfterKey);
        this.rawAfterKey = rawAfterKey;
        CompositeAggregatorBridge bridge = new CompositeAggregatorBridge(){
            private RoundingValuesSource valuesSource;
            private long afterKey = -1L;

            @Override
            protected boolean canOptimize() {
                if (this.canOptimize(sourceConfigs)) {
                    this.valuesSource = (RoundingValuesSource)sourceConfigs[0].valuesSource();
                    if (rawAfterKey != null) {
                        assert (rawAfterKey.size() == 1 && CompositeAggregator.this.formats.size() == 1);
                        this.afterKey = CompositeAggregator.this.formats.get(0).parseLong(rawAfterKey.get(0).toString(), false, () -> {
                            throw new IllegalArgumentException("now() is not supported in [after] key");
                        });
                    }
                    if (!this.valuesSource.getRounding().isUTC()) {
                        return false;
                    }
                    CompositeAggregator.this.bucketOrds = LongKeyedBucketOrds.build(context.bigArrays(), CardinalityUpperBound.ONE);
                    return true;
                }
                return false;
            }

            @Override
            protected void prepare() throws IOException {
                this.buildRanges(context);
            }

            @Override
            protected Rounding getRounding(long low, long high) {
                return this.valuesSource.getRounding();
            }

            @Override
            protected Rounding.Prepared getRoundingPrepared() {
                return this.valuesSource.getPreparedRounding();
            }

            @Override
            protected long[] processAfterKey(long[] bounds, long interval) {
                if (this.afterKey != -1L) {
                    bounds[0] = this.afterKey + interval;
                }
                return bounds;
            }

            @Override
            protected int getSize() {
                return size;
            }

            @Override
            protected Function<Long, Long> bucketOrdProducer() {
                return key -> CompositeAggregator.this.bucketOrds.add(0L, this.getRoundingPrepared().round((long)key));
            }
        };
        this.filterRewriteOptimizationContext = new FilterRewriteOptimizationContext(bridge, parent, this.subAggregators.length, context);
    }

    @Override
    protected void doClose() {
        try {
            Releasables.close((Releasable)this.queue);
            Releasables.close((Releasable)this.bucketOrds);
        }
        finally {
            Releasables.close((Releasable[])this.sources);
        }
    }

    @Override
    protected void doPreCollection() throws IOException {
        List<Aggregator> collectors = Arrays.asList(this.subAggregators);
        this.deferredCollectors = MultiBucketCollector.wrap(collectors);
        this.collectableSubAggregators = BucketCollector.NO_OP_COLLECTOR;
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.finishLeaf();
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        assert (owningBucketOrds.length == 1 && owningBucketOrds[0] == 0L);
        if (this.deferredCollectors != NO_OP_COLLECTOR) {
            this.runDeferredCollections();
        }
        int num = Math.min(this.size, this.queue.size());
        InternalComposite.InternalBucket[] buckets = new InternalComposite.InternalBucket[num];
        long[] bucketOrdsToCollect = new long[this.queue.size()];
        for (int i = 0; i < this.queue.size(); ++i) {
            bucketOrdsToCollect[i] = i;
        }
        InternalAggregations[] subAggsForBuckets = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        while (this.queue.size() > 0) {
            int slot = (Integer)this.queue.pop();
            CompositeKey compositeKey = this.queue.toCompositeKey(slot);
            InternalAggregations aggs = subAggsForBuckets[slot];
            long docCount = this.queue.getDocCount(slot);
            buckets[this.queue.size()] = new InternalComposite.InternalBucket(this.sourceNames, this.formats, compositeKey, this.reverseMuls, this.missingOrders, docCount, aggs);
        }
        if (this.bucketOrds != null) {
            HashMap<CompositeKey, InternalComposite.InternalBucket> bucketMap = new HashMap<CompositeKey, InternalComposite.InternalBucket>();
            for (InternalComposite.InternalBucket internalBucket : buckets) {
                bucketMap.put(internalBucket.getRawKey(), internalBucket);
            }
            LongKeyedBucketOrds.BucketOrdsEnum bucketOrdsEnum = this.bucketOrds.ordsEnum(0L);
            while (bucketOrdsEnum.next()) {
                Long bucketKeyValue = bucketOrdsEnum.value();
                CompositeKey key = new CompositeKey(bucketKeyValue);
                if (bucketMap.containsKey(key)) {
                    long docCount = this.bucketDocCount(bucketOrdsEnum.ord()) + ((InternalComposite.InternalBucket)bucketMap.get(key)).getDocCount();
                    ((InternalComposite.InternalBucket)bucketMap.get(key)).setDocCount(docCount);
                    continue;
                }
                InternalComposite.InternalBucket bucket = new InternalComposite.InternalBucket(this.sourceNames, this.formats, key, this.reverseMuls, this.missingOrders, this.bucketDocCount(bucketOrdsEnum.ord()), this.buildEmptySubAggregations());
                bucketMap.put(key, bucket);
            }
            ArrayList bucketList = new ArrayList(bucketMap.values());
            CollectionUtil.introSort(bucketList, InternalComposite.InternalBucket::compareKey);
            buckets = (InternalComposite.InternalBucket[])bucketList.subList(0, Math.min(this.size, bucketList.size())).toArray(InternalComposite.InternalBucket[]::new);
            num = buckets.length;
        }
        CompositeKey lastBucket = num > 0 ? buckets[num - 1].getRawKey() : null;
        return new InternalAggregation[]{new InternalComposite(this.name, this.size, this.sourceNames, this.formats, Arrays.asList(buckets), lastBucket, this.reverseMuls, this.missingOrders, this.earlyTerminated, this.metadata())};
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalComposite(this.name, this.size, this.sourceNames, this.formats, Collections.emptyList(), null, this.reverseMuls, this.missingOrders, false, this.metadata());
    }

    private void finishLeaf() {
        if (this.currentLeaf != null) {
            RoaringDocIdSet docIdSet = this.docIdSetBuilder.build();
            this.entries.add(new Entry(this.currentLeaf, (DocIdSet)docIdSet));
            this.currentLeaf = null;
            this.docIdSetBuilder = null;
        }
    }

    private boolean isMaybeMultivalued(LeafReaderContext context, SortField sortField) throws IOException {
        SortField.Type type = IndexSortConfig.getSortFieldType(sortField);
        switch (type) {
            case STRING: {
                SortedSetDocValues v1 = context.reader().getSortedSetDocValues(sortField.getField());
                return v1 != null && DocValues.unwrapSingleton((SortedSetDocValues)v1) == null;
            }
            case DOUBLE: 
            case FLOAT: 
            case LONG: 
            case INT: {
                SortedNumericDocValues v2 = context.reader().getSortedNumericDocValues(sortField.getField());
                return v2 != null && DocValues.unwrapSingleton((SortedNumericDocValues)v2) == null;
            }
        }
        return true;
    }

    private Sort buildIndexSortPrefix(LeafReaderContext context) throws IOException {
        Sort indexSort = context.reader().getMetaData().sort();
        if (indexSort == null) {
            return null;
        }
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        int end = Math.min(indexSort.getSort().length, this.sourceConfigs.length);
        for (int i = 0; i < end; ++i) {
            CompositeValuesSourceConfig sourceConfig = this.sourceConfigs[i];
            SingleDimensionValuesSource<?> source = this.sources[i];
            SortField indexSortField = indexSort.getSort()[i];
            if (source.fieldType == null || source.missingBucket || !indexSortField.getField().equals(source.fieldType.name()) || this.isMaybeMultivalued(context, indexSortField) || sourceConfig.hasScript()) break;
            if (indexSortField.getReverse() != (source.reverseMul == -1)) {
                if (i != 0) break;
                return new Sort(new SortField[]{indexSortField});
            }
            sortFields.add(indexSortField);
            if (sourceConfig.valuesSource() instanceof RoundingValuesSource) break;
        }
        return sortFields.isEmpty() ? null : new Sort(sortFields.toArray(new SortField[0]));
    }

    private int computeSortPrefixLen(Sort indexSortPrefix) {
        if (indexSortPrefix == null) {
            return 0;
        }
        if (indexSortPrefix.getSort()[0].getReverse() != (this.sources[0].reverseMul == -1)) {
            assert (indexSortPrefix.getSort().length == 1);
            return -1;
        }
        return indexSortPrefix.getSort().length;
    }

    private Sort applySortFieldRounding(Sort sort) {
        SortField[] sortFields = new SortField[sort.getSort().length];
        for (int i = 0; i < sort.getSort().length; ++i) {
            if (this.sourceConfigs[i].valuesSource() instanceof RoundingValuesSource) {
                final LongUnaryOperator round = ((RoundingValuesSource)this.sourceConfigs[i].valuesSource())::round;
                final SortedNumericSortField delegate = (SortedNumericSortField)sort.getSort()[i];
                sortFields[i] = new SortedNumericSortField(this, delegate.getField(), delegate.getNumericType(), delegate.getReverse()){

                    public boolean equals(Object obj) {
                        return delegate.equals(obj);
                    }

                    public int hashCode() {
                        return delegate.hashCode();
                    }

                    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
                        return new LongComparator(1, delegate.getField(), (Long)this.missingValue, delegate.getReverse(), Pruning.NONE){

                            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                                return new LongComparator.LongLeafComparator(context){

                                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                                        final NumericDocValues dvs = SortedNumericSelector.wrap((SortedNumericDocValues)DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field), (SortedNumericSelector.Type)delegate.getSelector(), (SortField.Type)delegate.getNumericType());
                                        return new NumericDocValues(){

                                            public long longValue() throws IOException {
                                                return round.applyAsLong(dvs.longValue());
                                            }

                                            public boolean advanceExact(int target) throws IOException {
                                                return dvs.advanceExact(target);
                                            }

                                            public int docID() {
                                                return dvs.docID();
                                            }

                                            public int nextDoc() throws IOException {
                                                return dvs.nextDoc();
                                            }

                                            public int advance(int target) throws IOException {
                                                return dvs.advance(target);
                                            }

                                            public long cost() {
                                                return dvs.cost();
                                            }
                                        };
                                    }
                                };
                            }
                        };
                    }
                };
                continue;
            }
            sortFields[i] = sort.getSort()[i];
        }
        return new Sort(sortFields);
    }

    private void processLeafFromQuery(LeafReaderContext ctx, Sort indexSortPrefix) throws IOException {
        DocValueFormat[] formats = new DocValueFormat[indexSortPrefix.getSort().length];
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = this.sources[i].format;
        }
        FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(new SortAndFormats(indexSortPrefix, formats), Arrays.copyOfRange(this.rawAfterKey.values(), 0, formats.length));
        if (indexSortPrefix.getSort().length < this.sources.length) {
            fieldDoc.doc = -1;
        }
        BooleanQuery newQuery = new BooleanQuery.Builder().add(this.context.query(), BooleanClause.Occur.MUST).add((Query)new SearchAfterSortedDocQuery(this.applySortFieldRounding(indexSortPrefix), fieldDoc), BooleanClause.Occur.FILTER).build();
        Weight weight = this.context.searcher().createWeight(this.context.searcher().rewrite((Query)newQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer scorer = weight.scorer(ctx);
        if (scorer != null) {
            DocIdSetIterator docIt = scorer.iterator();
            LeafBucketCollector inner = this.queue.getLeafCollector(ctx, this.getFirstPassCollector(this.docIdSetBuilder, indexSortPrefix.getSort().length));
            inner.setScorer((Scorable)scorer);
            Bits liveDocs = ctx.reader().getLiveDocs();
            while (docIt.nextDoc() != Integer.MAX_VALUE) {
                if (liveDocs != null && !liveDocs.get(docIt.docID())) continue;
                inner.collect(docIt.docID());
            }
        }
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        this.finishLeaf();
        return this.filterRewriteOptimizationContext.tryOptimize(ctx, this::incrementBucketDocCount, DateHistogramAggregatorBridge.segmentMatchAll(this.context, ctx));
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        SortedDocsProducer sortedDocsProducer;
        this.finishLeaf();
        boolean fillDocIdSet = this.deferredCollectors != NO_OP_COLLECTOR;
        Sort indexSortPrefix = this.buildIndexSortPrefix(ctx);
        int sortPrefixLen = this.computeSortPrefixLen(indexSortPrefix);
        SortedDocsProducer sortedDocsProducer2 = sortedDocsProducer = sortPrefixLen == 0 ? this.sources[0].createSortedDocsProducerOrNull((IndexReader)ctx.reader(), this.context.query()) : null;
        if (sortedDocsProducer != null) {
            DocIdSet docIdSet = sortedDocsProducer.processLeaf(this.context.query(), this.queue, ctx, fillDocIdSet);
            if (fillDocIdSet) {
                this.entries.add(new Entry(ctx, docIdSet));
            }
            this.earlyTerminated = true;
            throw new CollectionTerminatedException();
        }
        if (fillDocIdSet) {
            this.currentLeaf = ctx;
            this.docIdSetBuilder = new RoaringDocIdSet.Builder(ctx.reader().maxDoc());
        }
        if (this.rawAfterKey != null && sortPrefixLen > 0) {
            assert (indexSortPrefix != null);
            this.processLeafFromQuery(ctx, indexSortPrefix);
            throw new CollectionTerminatedException();
        }
        final LeafBucketCollector inner = this.queue.getLeafCollector(ctx, this.getFirstPassCollector(this.docIdSetBuilder, sortPrefixLen));
        return new LeafBucketCollector(this){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                inner.collect(doc);
            }
        };
    }

    private LeafBucketCollector getFirstPassCollector(final RoaringDocIdSet.Builder builder, final int indexSortPrefix) {
        return new LeafBucketCollector(){
            int lastDoc = -1;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                try {
                    long docCount = CompositeAggregator.this.docCountProvider.getDocCount(doc);
                    if (CompositeAggregator.this.queue.addIfCompetitive(indexSortPrefix, docCount) && builder != null && this.lastDoc != doc) {
                        builder.add(doc);
                        this.lastDoc = doc;
                    }
                }
                catch (CollectionTerminatedException exc) {
                    CompositeAggregator.this.earlyTerminated = true;
                    throw exc;
                }
            }
        };
    }

    private void runDeferredCollections() throws IOException {
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            Query query = this.context.query();
            weight = this.context.searcher().createWeight(this.context.searcher().rewrite(query), ScoreMode.COMPLETE, 1.0f);
        }
        this.deferredCollectors.preCollection();
        for (Entry entry : this.entries) {
            int docID;
            Scorer scorer;
            DocIdSetIterator docIdSetIterator = entry.docIdSet.iterator();
            if (docIdSetIterator == null) continue;
            LeafBucketCollector subCollector = this.deferredCollectors.getLeafCollector(entry.context);
            LeafBucketCollector collector = this.queue.getLeafCollector(entry.context, this.getSecondPassCollector(subCollector));
            DocIdSetIterator scorerIt = null;
            if (needsScores && (scorer = weight.scorer(entry.context)) != null) {
                scorerIt = scorer.iterator();
                subCollector.setScorer((Scorable)scorer);
            }
            while ((docID = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                if (needsScores) {
                    assert (scorerIt != null && scorerIt.docID() < docID);
                    scorerIt.advance(docID);
                    assert (scorerIt.docID() == docID);
                }
                collector.collect(docID);
            }
        }
        this.deferredCollectors.postCollection();
    }

    private LeafBucketCollector getSecondPassCollector(final LeafBucketCollector subCollector) {
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                Integer slot = CompositeAggregator.this.queue.getCurrentSlot();
                if (slot != null) {
                    subCollector.collect(doc, slot.intValue());
                }
            }
        };
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        this.filterRewriteOptimizationContext.populateDebugInfo(add);
    }

    private static class Entry {
        final LeafReaderContext context;
        final DocIdSet docIdSet;

        Entry(LeafReaderContext context, DocIdSet docIdSet) {
            this.context = context;
            this.docIdSet = docIdSet;
        }
    }
}

