/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class PollingIngestStats
implements Writeable,
ToXContentFragment {
    private final MessageProcessorStats messageProcessorStats;
    private final ConsumerStats consumerStats;

    public PollingIngestStats(MessageProcessorStats messageProcessorStats, ConsumerStats consumerStats) {
        this.messageProcessorStats = messageProcessorStats;
        this.consumerStats = consumerStats;
    }

    public PollingIngestStats(StreamInput in) throws IOException {
        long totalProcessedCount = in.readLong();
        this.messageProcessorStats = new MessageProcessorStats(totalProcessedCount);
        long totalPolledCount = in.readLong();
        this.consumerStats = new ConsumerStats(totalPolledCount);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.messageProcessorStats.getTotalProcessedCount());
        out.writeLong(this.consumerStats.getTotalPolledCount());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("polling_ingest_stats");
        builder.startObject("message_processor_stats");
        builder.field("total_processed_count", this.messageProcessorStats.getTotalProcessedCount());
        builder.endObject();
        builder.startObject("consumer_stats");
        builder.field("total_polled_count", this.consumerStats.getTotalPolledCount());
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public MessageProcessorStats getMessageProcessorStats() {
        return this.messageProcessorStats;
    }

    public ConsumerStats getConsumerStats() {
        return this.consumerStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingIngestStats)) {
            return false;
        }
        PollingIngestStats that = (PollingIngestStats)o;
        return Objects.equals(this.messageProcessorStats, that.messageProcessorStats) && Objects.equals(this.consumerStats, that.consumerStats);
    }

    public int hashCode() {
        return Objects.hash(this.messageProcessorStats, this.consumerStats);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ExperimentalApi
    public static class MessageProcessorStats {
        private final long totalProcessedCount;

        public MessageProcessorStats(long totalProcessedCount) {
            this.totalProcessedCount = totalProcessedCount;
        }

        public long getTotalProcessedCount() {
            return this.totalProcessedCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageProcessorStats)) {
                return false;
            }
            MessageProcessorStats that = (MessageProcessorStats)o;
            return this.totalProcessedCount == that.totalProcessedCount;
        }

        public int hashCode() {
            return Objects.hash(this.totalProcessedCount);
        }
    }

    @ExperimentalApi
    public static class ConsumerStats {
        private final long totalPolledCount;

        public ConsumerStats(long totalPolledCount) {
            this.totalPolledCount = totalPolledCount;
        }

        public long getTotalPolledCount() {
            return this.totalPolledCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConsumerStats)) {
                return false;
            }
            ConsumerStats that = (ConsumerStats)o;
            return this.totalPolledCount == that.totalPolledCount;
        }

        public int hashCode() {
            return Objects.hash(this.totalPolledCount);
        }
    }

    @ExperimentalApi
    public static class Builder {
        private long totalProcessedCount;
        private long totalPolledCount;

        public Builder setTotalProcessedCount(long totalProcessedCount) {
            this.totalProcessedCount = totalProcessedCount;
            return this;
        }

        public Builder setTotalPolledCount(long totalPolledCount) {
            this.totalPolledCount = totalPolledCount;
            return this;
        }

        public PollingIngestStats build() {
            MessageProcessorStats messageProcessorStats = new MessageProcessorStats(this.totalProcessedCount);
            ConsumerStats consumerStats = new ConsumerStats(this.totalPolledCount);
            return new PollingIngestStats(messageProcessorStats, consumerStats);
        }
    }
}

