/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.util.RequestUtils;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IngestionShardConsumer;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.index.VersionType;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.IngestionEngine;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.Uid;
import org.opensearch.indices.pollingingest.IngestionErrorStrategy;

public class MessageProcessorRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(MessageProcessorRunnable.class);
    private static final String ID = "_id";
    private static final String OP_TYPE = "_op_type";
    private static final String SOURCE = "_source";
    private static final int WAIT_BEFORE_RETRY_DURATION_MS = 5000;
    private volatile IngestionErrorStrategy errorStrategy;
    private final BlockingQueue<IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message>> blockingQueue;
    private final MessageProcessor messageProcessor;
    private final CounterMetric stats = new CounterMetric();

    public MessageProcessorRunnable(BlockingQueue<IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message>> blockingQueue, IngestionEngine engine, IngestionErrorStrategy errorStrategy) {
        this(blockingQueue, new MessageProcessor(engine), errorStrategy);
    }

    MessageProcessorRunnable(BlockingQueue<IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message>> blockingQueue, MessageProcessor messageProcessor, IngestionErrorStrategy errorStrategy) {
        this.blockingQueue = Objects.requireNonNull(blockingQueue);
        this.messageProcessor = messageProcessor;
        this.errorStrategy = errorStrategy;
    }

    private static BytesReference convertToBytes(Object object) throws IOException {
        assert (object instanceof Map);
        return BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().map((Map)object));
    }

    BlockingQueue<IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message>> getBlockingQueue() {
        return this.blockingQueue;
    }

    @Override
    public void run() {
        IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message> readResult = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (readResult == null) {
                    readResult = this.blockingQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                logger.debug("MessageProcessorRunnable poll interruptedException", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (readResult == null) continue;
            try {
                this.stats.inc();
                this.messageProcessor.process(readResult.getMessage(), readResult.getPointer());
                readResult = null;
            }
            catch (Exception e) {
                this.errorStrategy.handleError(e, IngestionErrorStrategy.ErrorStage.PROCESSING);
                if (this.errorStrategy.shouldIgnoreError(e, IngestionErrorStrategy.ErrorStage.PROCESSING)) {
                    readResult = null;
                    continue;
                }
                this.waitBeforeRetry();
            }
        }
    }

    private void waitBeforeRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            logger.debug("MessageProcessor thread interrupted while waiting for retry", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public CounterMetric getStats() {
        return this.stats;
    }

    public IngestionErrorStrategy getErrorStrategy() {
        return this.errorStrategy;
    }

    public void setErrorStrategy(IngestionErrorStrategy errorStrategy) {
        this.errorStrategy = errorStrategy;
    }

    static class MessageProcessor {
        private final IngestionEngine engine;
        private final String index;

        MessageProcessor(IngestionEngine engine) {
            this(engine, engine.config().getIndexSettings().getIndex().getName());
        }

        MessageProcessor(IngestionEngine engine, String index) {
            this.engine = engine;
            this.index = index;
        }

        protected void process(Message message, IngestionShardPointer pointer) {
            byte[] payload = (byte[])message.getPayload();
            try {
                Engine.Operation operation = this.getOperation(payload, pointer);
                switch (operation.operationType()) {
                    case INDEX: {
                        this.engine.indexInternal((Engine.Index)operation);
                        break;
                    }
                    case DELETE: {
                        this.engine.deleteInternal((Engine.Delete)operation);
                        break;
                    }
                    case NO_OP: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid operation: " + String.valueOf(operation));
                    }
                }
            }
            catch (IOException e) {
                logger.error("Failed to process operation from message {} at pointer {}: {}", (Object)message, (Object)pointer, (Object)e);
                throw new RuntimeException(e);
            }
        }

        protected Engine.Operation getOperation(byte[] payload, IngestionShardPointer pointer) throws IOException {
            Engine.Operation operation;
            Map<String, Object> payloadMap = this.getParsedPayloadMap(payload);
            if (payloadMap.containsKey(MessageProcessorRunnable.OP_TYPE) && !(payloadMap.get(MessageProcessorRunnable.OP_TYPE) instanceof String)) {
                logger.error("_op_type field is of type {} but not string, skipping the message", payloadMap.get(MessageProcessorRunnable.OP_TYPE).getClass());
                return null;
            }
            String id = (String)payloadMap.get(MessageProcessorRunnable.ID);
            long autoGeneratedIdTimestamp = -1L;
            if (Strings.isNullOrEmpty((String)id)) {
                id = RequestUtils.generateID();
                payloadMap.put(MessageProcessorRunnable.ID, id);
                autoGeneratedIdTimestamp = System.currentTimeMillis();
            }
            String opTypeString = (String)payloadMap.getOrDefault(MessageProcessorRunnable.OP_TYPE, "index");
            DocWriteRequest.OpType opType = DocWriteRequest.OpType.fromString(opTypeString);
            switch (opType) {
                case INDEX: {
                    if (!payloadMap.containsKey(MessageProcessorRunnable.SOURCE)) {
                        logger.error("missing _source field, skipping the message");
                        return null;
                    }
                    if (!(payloadMap.get(MessageProcessorRunnable.SOURCE) instanceof Map)) {
                        logger.error("_source field does not contain a map, skipping the message");
                        return null;
                    }
                    BytesReference source = MessageProcessorRunnable.convertToBytes(payloadMap.get(MessageProcessorRunnable.SOURCE));
                    SourceToParse sourceToParse = new SourceToParse(this.index, id, source, MediaTypeRegistry.xContentType((BytesReference)source), null);
                    ParsedDocument doc = this.engine.getDocumentMapperForType().getDocumentMapper().parse(sourceToParse);
                    ParseContext.Document document = doc.rootDoc();
                    document.add((IndexableField)pointer.asPointField("_offset"));
                    document.add((IndexableField)new StoredField("_offset", pointer.asString()));
                    operation = new Engine.Index(new Term(MessageProcessorRunnable.ID, Uid.encodeId(id)), doc, 0L, 1L, -3L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, System.nanoTime(), autoGeneratedIdTimestamp, false, -2L, 0L);
                    break;
                }
                case DELETE: {
                    if (autoGeneratedIdTimestamp != -1L) {
                        logger.info("Delete operation without ID received, and will be dropped.");
                        operation = new Engine.NoOp(0L, 1L, Engine.Operation.Origin.PRIMARY, System.nanoTime(), "Delete operation is missing ID");
                        break;
                    }
                    operation = new Engine.Delete(id, new Term(MessageProcessorRunnable.ID, Uid.encodeId(id)), 0L, 1L, -3L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, System.nanoTime(), -2L, 0L);
                    break;
                }
                default: {
                    logger.error("Unsupported operation type {}", (Object)opType);
                    return null;
                }
            }
            return operation;
        }

        private Map<String, Object> getParsedPayloadMap(byte[] payload) {
            BytesArray payloadBR = new BytesArray(payload);
            Map payloadMap = (Map)XContentHelper.convertToMap((BytesReference)payloadBR, false, MediaTypeRegistry.xContentType((BytesReference)payloadBR)).v2();
            return payloadMap;
        }
    }
}

