/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class FeatureFlags {
    private static final String OS_EXPERIMENTAL_PREFIX = "opensearch.experimental.";
    static final String FEATURE_FLAG_PREFIX = "opensearch.experimental.feature.";
    public static final String REMOTE_STORE_MIGRATION_EXPERIMENTAL = "opensearch.experimental.feature.remote_store.migration.enabled";
    public static final String SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY = "opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled";
    public static final Setting<Boolean> SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_SETTING = Setting.boolSetting("opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled", false, Setting.Property.NodeScope);
    public static final String EXTENSIONS = "opensearch.experimental.feature.extensions.enabled";
    public static final String TELEMETRY = "opensearch.experimental.feature.telemetry.enabled";
    public static final String DATETIME_FORMATTER_CACHING = "opensearch.experimental.optimization.datetime_formatter_caching.enabled";
    public static final String WRITABLE_WARM_INDEX_EXPERIMENTAL_FLAG = "opensearch.experimental.feature.writable_warm_index.enabled";
    public static final String BACKGROUND_TASK_EXECUTION_EXPERIMENTAL = "opensearch.experimental.feature.task.background.enabled";
    public static final String READER_WRITER_SPLIT_EXPERIMENTAL = "opensearch.experimental.feature.read.write.split.enabled";
    public static final Setting<Boolean> REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING = Setting.boolSetting("opensearch.experimental.feature.remote_store.migration.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> EXTENSIONS_SETTING = Setting.boolSetting("opensearch.experimental.feature.extensions.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> TELEMETRY_SETTING = Setting.boolSetting("opensearch.experimental.feature.telemetry.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> DATETIME_FORMATTER_CACHING_SETTING = Setting.boolSetting("opensearch.experimental.optimization.datetime_formatter_caching.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> WRITABLE_WARM_INDEX_SETTING = Setting.boolSetting("opensearch.experimental.feature.writable_warm_index.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> READER_WRITER_SPLIT_EXPERIMENTAL_SETTING = Setting.boolSetting("opensearch.experimental.feature.read.write.split.enabled", false, Setting.Property.NodeScope);
    public static final String STAR_TREE_INDEX = "opensearch.experimental.feature.composite_index.star_tree.enabled";
    public static final Setting<Boolean> STAR_TREE_INDEX_SETTING = Setting.boolSetting("opensearch.experimental.feature.composite_index.star_tree.enabled", false, Setting.Property.NodeScope);
    public static final String APPLICATION_BASED_CONFIGURATION_TEMPLATES = "opensearch.experimental.feature.application_templates.enabled";
    public static final Setting<Boolean> APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING = Setting.boolSetting("opensearch.experimental.feature.application_templates.enabled", false, Setting.Property.NodeScope);
    public static final String TERM_VERSION_PRECOMMIT_ENABLE = "opensearch.experimental.optimization.termversion.precommit.enabled";
    public static final Setting<Boolean> TERM_VERSION_PRECOMMIT_ENABLE_SETTING = Setting.boolSetting("opensearch.experimental.optimization.termversion.precommit.enabled", false, Setting.Property.NodeScope);
    public static final String ARROW_STREAMS = "opensearch.experimental.feature.arrow.streams.enabled";
    public static final Setting<Boolean> ARROW_STREAMS_SETTING = Setting.boolSetting("opensearch.experimental.feature.arrow.streams.enabled", false, Setting.Property.NodeScope);
    private static final FeatureFlagsImpl featureFlagsImpl = new FeatureFlagsImpl();

    public static void initializeFeatureFlags(Settings openSearchSettings) {
        featureFlagsImpl.initializeFeatureFlags(openSearchSettings);
    }

    public static boolean isEnabled(String featureFlagName) {
        return featureFlagsImpl.isEnabled(featureFlagName);
    }

    public static boolean isEnabled(Setting<Boolean> featureFlag) {
        return featureFlagsImpl.isEnabled(featureFlag);
    }

    static class FeatureFlagsImpl {
        private static final String TEST_FLAG = "test.flag.enabled";
        private static final Setting<Boolean> TEST_FLAG_SETTING = Setting.boolSetting("test.flag.enabled", false, Setting.Property.NodeScope);
        private final ConcurrentHashMap<Setting<Boolean>, Boolean> featureFlags = new ConcurrentHashMap<Setting<Boolean>, Boolean>(){
            {
                this.put(TEST_FLAG_SETTING, TEST_FLAG_SETTING.get(Settings.EMPTY));
                this.put(REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING, REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING.getDefault(Settings.EMPTY));
                this.put(EXTENSIONS_SETTING, EXTENSIONS_SETTING.getDefault(Settings.EMPTY));
                this.put(TELEMETRY_SETTING, TELEMETRY_SETTING.getDefault(Settings.EMPTY));
                this.put(DATETIME_FORMATTER_CACHING_SETTING, DATETIME_FORMATTER_CACHING_SETTING.getDefault(Settings.EMPTY));
                this.put(WRITABLE_WARM_INDEX_SETTING, WRITABLE_WARM_INDEX_SETTING.getDefault(Settings.EMPTY));
                this.put(STAR_TREE_INDEX_SETTING, STAR_TREE_INDEX_SETTING.getDefault(Settings.EMPTY));
                this.put(APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING, APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING.getDefault(Settings.EMPTY));
                this.put(READER_WRITER_SPLIT_EXPERIMENTAL_SETTING, READER_WRITER_SPLIT_EXPERIMENTAL_SETTING.getDefault(Settings.EMPTY));
                this.put(TERM_VERSION_PRECOMMIT_ENABLE_SETTING, TERM_VERSION_PRECOMMIT_ENABLE_SETTING.getDefault(Settings.EMPTY));
                this.put(ARROW_STREAMS_SETTING, ARROW_STREAMS_SETTING.getDefault(Settings.EMPTY));
                this.put(SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_SETTING, SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_SETTING.getDefault(Settings.EMPTY));
            }
        };

        FeatureFlagsImpl() {
            this.initFromDefaults();
            this.initFromSysProperties();
        }

        void initializeFeatureFlags(Settings openSearchSettings) {
            this.initFromDefaults();
            this.initFromSysProperties();
            this.initFromSettings(openSearchSettings);
        }

        private void initFromDefaults() {
            for (Setting ff : this.featureFlags.keySet()) {
                if (TestUtils.FlagWriteLock.isLocked(ff.getKey())) continue;
                this.featureFlags.put(ff, (Boolean)ff.getDefault(Settings.EMPTY));
            }
        }

        private void initFromSysProperties() {
            for (Setting ff : this.featureFlags.keySet()) {
                String prop;
                if (TestUtils.FlagWriteLock.isLocked(ff.getKey()) || (prop = System.getProperty(ff.getKey())) == null) continue;
                this.featureFlags.put(ff, Boolean.valueOf(prop));
            }
        }

        private void initFromSettings(Settings settings) {
            for (Setting ff : this.featureFlags.keySet()) {
                if (!settings.hasValue(ff.getKey()) || TestUtils.FlagWriteLock.isLocked(ff.getKey())) continue;
                this.featureFlags.put(ff, settings.getAsBoolean(ff.getKey(), (Boolean)ff.getDefault(settings)));
            }
        }

        boolean isEnabled(Setting<Boolean> ff) {
            return this.featureFlags.getOrDefault(ff, false);
        }

        boolean isEnabled(String featureFlagName) {
            for (Setting ff : this.featureFlags.keySet()) {
                if (!ff.getKey().equals(featureFlagName)) continue;
                return this.featureFlags.get(ff);
            }
            return false;
        }

        void set(String featureFlagName, Boolean value) {
            for (Setting ff : this.featureFlags.keySet()) {
                if (!ff.getKey().equals(featureFlagName)) continue;
                this.featureFlags.put(ff, value);
            }
        }
    }

    public static class TestUtils {
        public static void with(String flag, ThrowingRunnable action) throws Exception {
            try (FlagWriteLock ignored = new FlagWriteLock(flag);){
                action.run();
            }
        }

        public static void with(String flag, Boolean value, ThrowingRunnable action) throws Exception {
            try (FlagWriteLock ignored = new FlagWriteLock(flag, value);){
                action.run();
            }
        }

        public static class FlagWriteLock
        implements AutoCloseable {
            private static final Set<String> writeLocks = new HashSet<String>();
            private final String flag;
            private final Boolean prev;

            public static boolean isLocked(String flag) {
                return writeLocks.contains(flag);
            }

            public FlagWriteLock(String flag) {
                this(flag, true);
            }

            public FlagWriteLock(String flag, Boolean value) {
                if (writeLocks.contains(flag)) {
                    throw new RuntimeException("Cannot initialize second write lock for feature flag: " + flag);
                }
                this.flag = flag;
                this.prev = featureFlagsImpl.isEnabled(flag);
                writeLocks.add(flag);
                featureFlagsImpl.set(flag, value);
            }

            public void unlock() {
                featureFlagsImpl.set(this.flag, this.prev);
                writeLocks.remove(this.flag);
            }

            @Override
            public void close() {
                featureFlagsImpl.set(this.flag, this.prev);
                writeLocks.remove(this.flag);
            }
        }

        @FunctionalInterface
        public static interface ThrowingRunnable {
            public void run() throws Exception;
        }
    }
}

