/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.transport.RemoteClusterService;

@PublicApi(since="1.0.0")
public abstract class DiscoveryNodeRole
implements Comparable<DiscoveryNodeRole> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DiscoveryNodeRole.class);
    public static final String MASTER_ROLE_DEPRECATION_MESSAGE = "Assigning [master] role in setting [node.roles] is deprecated. To promote inclusive language, please use [cluster_manager] role instead.";
    private final String roleName;
    private final String roleNameAbbreviation;
    private final boolean canContainData;
    private final boolean isKnownRole;
    private final boolean isDynamicRole;
    public static final DiscoveryNodeRole DATA_ROLE = new DiscoveryNodeRole("data", "d", true){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.data", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final DiscoveryNodeRole INGEST_ROLE = new DiscoveryNodeRole("ingest", "i"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.ingest", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    @Deprecated
    public static final DiscoveryNodeRole MASTER_ROLE = new DiscoveryNodeRole("master", "m"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.master", false, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }

        @Override
        public void validateRole(List<DiscoveryNodeRole> roles) {
            deprecationLogger.deprecate("node_role_master", DiscoveryNodeRole.MASTER_ROLE_DEPRECATION_MESSAGE, new Object[0]);
        }
    };
    public static final DiscoveryNodeRole CLUSTER_MANAGER_ROLE = new DiscoveryNodeRole("cluster_manager", "m"){

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }

        @Override
        public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
            if (nodeVersion.onOrAfter(Version.V_2_0_0)) {
                return this;
            }
            return MASTER_ROLE;
        }

        @Override
        public void validateRole(List<DiscoveryNodeRole> roles) {
            if (roles.contains(MASTER_ROLE)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The two roles [%s, %s] can not be assigned together to a node. %s", MASTER_ROLE.roleName(), CLUSTER_MANAGER_ROLE.roleName(), DiscoveryNodeRole.MASTER_ROLE_DEPRECATION_MESSAGE));
            }
        }

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return !Booleans.isBoolean((String)settings.get("node.master"));
        }
    };
    public static final DiscoveryNodeRole REMOTE_CLUSTER_CLIENT_ROLE = new DiscoveryNodeRole("remote_cluster_client", "r"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.remote_cluster_client", RemoteClusterService.ENABLE_REMOTE_CLUSTERS, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final DiscoveryNodeRole WARM_ROLE = new DiscoveryNodeRole("warm", "w", true){

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }
    };
    public static final DiscoveryNodeRole SEARCH_ROLE = new DiscoveryNodeRole("search", "s", true){

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }

        @Override
        public void validateRole(List<DiscoveryNodeRole> roles) {
            for (DiscoveryNodeRole role : roles) {
                if (role.equals(SEARCH_ROLE)) continue;
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s role cannot be combined with any other role on a node.", SEARCH_ROLE.roleName()));
            }
        }
    };
    public static SortedSet<DiscoveryNodeRole> BUILT_IN_ROLES = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, CLUSTER_MANAGER_ROLE, REMOTE_CLUSTER_CLIENT_ROLE, WARM_ROLE, SEARCH_ROLE)));
    public static final Version REMOTE_CLUSTER_CLIENT_ROLE_VERSION = LegacyESVersion.fromString((String)"7.8.0");
    static SortedSet<DiscoveryNodeRole> LEGACY_ROLES = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, MASTER_ROLE)));

    public final String roleName() {
        return this.roleName;
    }

    public final String roleNameAbbreviation() {
        return this.roleNameAbbreviation;
    }

    public final boolean canContainData() {
        return this.canContainData;
    }

    public final boolean isKnownRole() {
        return this.isKnownRole;
    }

    public final boolean isDynamicRole() {
        return this.isDynamicRole;
    }

    public boolean isEnabledByDefault(Settings settings) {
        return this.legacySetting() != null && this.legacySetting().get(settings) != false;
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation) {
        this(roleName, roleNameAbbreviation, false);
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
        this(true, false, roleName, roleNameAbbreviation, canContainData);
    }

    private DiscoveryNodeRole(boolean isKnownRole, boolean isDynamicRole, String roleName, String roleNameAbbreviation, boolean canContainData) {
        this.isKnownRole = isKnownRole;
        this.isDynamicRole = isDynamicRole;
        this.roleName = Objects.requireNonNull(roleName).toLowerCase(Locale.ROOT);
        this.roleNameAbbreviation = Objects.requireNonNull(roleNameAbbreviation).toLowerCase(Locale.ROOT);
        this.canContainData = canContainData;
    }

    public abstract Setting<Boolean> legacySetting();

    public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
        return this;
    }

    public void validateRole(List<DiscoveryNodeRole> roles) {
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNodeRole that = (DiscoveryNodeRole)o;
        return this.roleName.equals(that.roleName) && this.roleNameAbbreviation.equals(that.roleNameAbbreviation) && this.canContainData == that.canContainData && this.isKnownRole == that.isKnownRole && this.isDynamicRole == that.isDynamicRole;
    }

    public final int hashCode() {
        return Objects.hash(this.isKnownRole, this.isDynamicRole, this.roleName(), this.roleNameAbbreviation(), this.canContainData());
    }

    @Override
    public final int compareTo(DiscoveryNodeRole o) {
        return this.roleName.compareTo(o.roleName);
    }

    public final String toString() {
        return "DiscoveryNodeRole{roleName='" + this.roleName + "', roleNameAbbreviation='" + this.roleNameAbbreviation + "', canContainData=" + this.canContainData + (this.isKnownRole ? "" : ", isKnownRole=false") + (this.isDynamicRole ? "" : ", isDynamicRole=false") + "}";
    }

    @Deprecated
    public boolean isClusterManager() {
        return this.equals(CLUSTER_MANAGER_ROLE) || this.equals(MASTER_ROLE);
    }

    static class DynamicRole
    extends DiscoveryNodeRole {
        DynamicRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
            super(false, true, roleName, roleNameAbbreviation, canContainData);
        }

        @Override
        public Setting<Boolean> legacySetting() {
            return null;
        }
    }

    static class UnknownRole
    extends DiscoveryNodeRole {
        UnknownRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
            super(false, false, roleName, roleNameAbbreviation, canContainData);
        }

        @Override
        public Setting<Boolean> legacySetting() {
            assert (false);
            return Setting.boolSetting("node. " + this.roleName(), false, Setting.Property.NodeScope);
        }
    }
}

