/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.wlm;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.admin.cluster.wlm.WlmStatsRequest;
import org.opensearch.action.admin.cluster.wlm.WlmStatsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.wlm.QueryGroupService;
import org.opensearch.wlm.stats.WlmStats;

public class TransportWlmStatsAction
extends TransportNodesAction<WlmStatsRequest, WlmStatsResponse, WlmStatsRequest, WlmStats> {
    final QueryGroupService queryGroupService;

    @Inject
    public TransportWlmStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, QueryGroupService queryGroupService, ActionFilters actionFilters) {
        super("cluster:monitor/wlm/stats", threadPool, clusterService, transportService, actionFilters, WlmStatsRequest::new, WlmStatsRequest::new, "management", WlmStats.class);
        this.queryGroupService = queryGroupService;
    }

    @Override
    protected WlmStatsResponse newResponse(WlmStatsRequest request, List<WlmStats> wlmStats, List<FailedNodeException> failures) {
        return new WlmStatsResponse(this.clusterService.getClusterName(), wlmStats, failures);
    }

    @Override
    protected WlmStatsRequest newNodeRequest(WlmStatsRequest request) {
        return request;
    }

    @Override
    protected WlmStats newNodeResponse(StreamInput in) throws IOException {
        return new WlmStats(in);
    }

    @Override
    protected WlmStats nodeOperation(WlmStatsRequest wlmStatsRequest) {
        assert (this.transportService.getLocalNode() != null);
        return new WlmStats(this.transportService.getLocalNode(), this.queryGroupService.nodeStats(wlmStatsRequest.getQueryGroupIds(), wlmStatsRequest.isBreach()));
    }
}

