/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.task;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.breaker.MLCircuitBreakerService;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskResponse;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.engine.indices.MLInputDatasetHandler;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionLevelStat;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.task.MLTaskRunner;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.client.Client;

public class MLExecuteTaskRunner
extends MLTaskRunner<MLExecuteTaskRequest, MLExecuteTaskResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(MLExecuteTaskRunner.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MLInputDatasetHandler mlInputDatasetHandler;
    protected final DiscoveryNodeHelper nodeHelper;
    private final MLEngine mlEngine;
    private volatile Boolean isPythonModelEnabled;

    public MLExecuteTaskRunner(ThreadPool threadPool, ClusterService clusterService, Client client, MLTaskManager mlTaskManager, MLStats mlStats, MLInputDatasetHandler mlInputDatasetHandler, MLTaskDispatcher mlTaskDispatcher, MLCircuitBreakerService mlCircuitBreakerService, DiscoveryNodeHelper nodeHelper, MLEngine mlEngine) {
        super(mlTaskManager, mlStats, nodeHelper, mlTaskDispatcher, mlCircuitBreakerService, clusterService);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.mlInputDatasetHandler = mlInputDatasetHandler;
        this.nodeHelper = nodeHelper;
        this.mlEngine = mlEngine;
        this.isPythonModelEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_ENABLE_INHOUSE_PYTHON_MODEL.get(this.clusterService.getSettings());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ENABLE_INHOUSE_PYTHON_MODEL, it -> {
            this.isPythonModelEnabled = it;
        });
    }

    @Override
    protected String getTransportActionName() {
        return "cluster:admin/opensearch/ml/execute";
    }

    @Override
    protected TransportResponseHandler<MLExecuteTaskResponse> getResponseHandler(ActionListener<MLExecuteTaskResponse> listener) {
        return new ActionListenerResponseHandler(listener, MLExecuteTaskResponse::new);
    }

    @Override
    protected void executeTask(MLExecuteTaskRequest request, ActionListener<MLExecuteTaskResponse> listener) {
        this.threadPool.executor("opensearch_ml_execute").execute(() -> {
            try {
                this.mlStats.getStat(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).increment();
                this.mlStats.getStat(MLNodeLevelStat.ML_REQUEST_COUNT).increment();
                this.mlStats.createCounterStatIfAbsent(request.getFunctionName(), ActionName.EXECUTE, MLActionLevelStat.ML_ACTION_REQUEST_COUNT).increment();
                Input input = request.getInput();
                FunctionName functionName = request.getFunctionName();
                if (FunctionName.METRICS_CORRELATION.equals((Object)functionName) && !this.isPythonModelEnabled.booleanValue()) {
                    IllegalArgumentException exception = new IllegalArgumentException("This algorithm is not enabled from settings");
                    listener.onFailure((Exception)exception);
                    return;
                }
                this.mlEngine.execute(input, ActionListener.wrap(output -> {
                    MLExecuteTaskResponse response = new MLExecuteTaskResponse(functionName, output);
                    listener.onResponse((Object)response);
                }, e -> listener.onFailure(e)));
            }
            catch (Exception e2) {
                this.mlStats.createCounterStatIfAbsent(request.getFunctionName(), ActionName.EXECUTE, MLActionLevelStat.ML_ACTION_FAILURE_COUNT).increment();
                listener.onFailure(e2);
            }
            finally {
                this.mlStats.getStat(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT).decrement();
            }
        });
    }
}

