/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLPredictionAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLPredictionAction.class);
    private static final String ML_PREDICTION_ACTION = "ml_prediction_action";
    private final MLModelManager modelManager;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLPredictionAction(MLModelManager modelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.modelManager = modelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_PREDICTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_predict/{%s}/{%s}", "/_plugins/_ml", "algorithm", "model_id")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_predict", "/_plugins/_ml", "model_id")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_batch_predict", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String userAlgorithm = request.param("algorithm");
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        Optional<FunctionName> functionName = this.modelManager.getOptionalModelFunctionName(modelId);
        if (functionName.isPresent()) {
            MLPredictionTaskRequest predictionRequest = this.getRequest(modelId, functionName.get().name(), Objects.requireNonNullElse(userAlgorithm, functionName.get().name()), request);
            return channel -> client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, (ActionListener)new RestToXContentListener(channel));
        }
        return channel -> {
            ActionListener listener = ActionListener.wrap(mlModel -> {
                String modelType = mlModel.getAlgorithm().name();
                String modelAlgorithm = Objects.requireNonNullElse(userAlgorithm, mlModel.getAlgorithm().name());
                client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)this.getRequest(modelId, modelType, modelAlgorithm, request), (ActionListener)new RestToXContentListener(channel));
            }, e -> {
                log.error("Failed to get ML model", (Throwable)e);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.NOT_FOUND, e));
                }
                catch (IOException ex) {
                    log.error("Failed to send error response", (Throwable)ex);
                }
            });
            try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
                this.modelManager.getModel(modelId, TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request), (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        };
    }

    @VisibleForTesting
    MLPredictionTaskRequest getRequest(String modelId, String modelType, String userAlgorithm, RestRequest request) throws IOException {
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        ConnectorAction.ActionType actionType = ConnectorAction.ActionType.from((String)RestActionUtils.getActionTypeFromRestRequest(request));
        if (FunctionName.REMOTE.name().equals(modelType) && !this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (FunctionName.isDLModel((FunctionName)FunctionName.from((String)modelType.toUpperCase(Locale.ROOT))) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
            throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
        }
        if (ConnectorAction.ActionType.BATCH_PREDICT == actionType && !this.mlFeatureEnabledSetting.isOfflineBatchInferenceEnabled().booleanValue()) {
            throw new IllegalStateException("Offline Batch Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_inference_enabled\" to true.");
        }
        if (!ConnectorAction.ActionType.isValidActionInModelPrediction((ConnectorAction.ActionType)actionType)) {
            throw new IllegalArgumentException("Wrong action type in the rest request path!");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = MLInput.parse((XContentParser)parser, (String)userAlgorithm, (ConnectorAction.ActionType)actionType);
        return new MLPredictionTaskRequest(modelId, mlInput, null, tenantId);
    }
}

