/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.transport.config.MLConfigGetAction;
import org.opensearch.ml.common.transport.config.MLConfigGetRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLGetConfigAction
extends BaseRestHandler {
    private static final String ML_GET_CONFIG_ACTION = "ml_get_config_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetConfigAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_CONFIG_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/config/{%s}", "/_plugins/_ml", "config_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLConfigGetRequest mlConfigGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLConfigGetAction.INSTANCE, (ActionRequest)mlConfigGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLConfigGetRequest getRequest(RestRequest request) throws IOException {
        String configID = RestActionUtils.getParameterId(request, "config_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        if (configID.equals("master_key")) {
            throw new IllegalArgumentException("You are not allowed to access this config doc");
        }
        return new MLConfigGetRequest(configID, tenantId);
    }
}

