/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.helper;

import java.util.Collection;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Client;

public class ConnectorAccessControlHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(ConnectorAccessControlHelper.class);
    private volatile Boolean connectorAccessControlEnabled;

    public ConnectorAccessControlHelper(ClusterService clusterService, Settings settings) {
        this.connectorAccessControlEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_CONNECTOR_ACCESS_CONTROL_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_CONNECTOR_ACCESS_CONTROL_ENABLED, it -> {
            this.connectorAccessControlEnabled = it;
        });
    }

    public boolean hasPermission(User user, Connector connector) {
        return this.accessControlNotEnabled(user) || this.isAdmin(user) || this.previouslyPublicConnector(connector) || this.isPublicConnector(connector) || this.isPrivateConnector(connector) && this.isOwner(user, connector.getOwner()) || this.isRestrictedConnector(connector) && this.isUserHasBackendRole(user, connector);
    }

    public void validateConnectorAccess(Client client, String connectorId, ActionListener<Boolean> listener) {
        User user = RestActionUtils.getUserContext(client);
        if (this.isAdmin(user) || this.accessControlNotEnabled(user)) {
            listener.onResponse((Object)true);
            return;
        }
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.getConnector(client, connectorId, (ActionListener<Connector>)ActionListener.wrap(connector -> {
                boolean hasPermission = this.hasPermission(user, (Connector)connector);
                wrappedListener.onResponse((Object)hasPermission);
            }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to validate Access for connector:{}", (Object)connectorId, (Object)e);
            listener.onFailure(e);
        }
    }

    public void validateConnectorAccess(SdkClient sdkClient, Client client, String connectorId, String tenantId, MLFeatureEnabledSetting mlFeatureEnabledSetting, ActionListener<Boolean> listener) {
        User user = RestActionUtils.getUserContext(client);
        if (!mlFeatureEnabledSetting.isMultiTenancyEnabled() && (this.isAdmin(user) || this.accessControlNotEnabled(user))) {
            listener.onResponse((Object)true);
            return;
        }
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(true);
            GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).tenantId(tenantId)).id(connectorId)).fetchSourceContext(fetchSourceContext).build();
            this.getConnector(sdkClient, client, context, getDataObjectRequest, connectorId, (ActionListener<Connector>)ActionListener.wrap(connector -> {
                if (TenantAwareHelper.validateTenantResource(mlFeatureEnabledSetting, tenantId, connector.getTenantId(), listener)) {
                    boolean hasPermission = this.hasPermission(user, (Connector)connector);
                    wrappedListener.onResponse((Object)hasPermission);
                }
            }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to validate Access for connector:{}", (Object)connectorId, (Object)e);
            listener.onFailure(e);
        }
    }

    public boolean validateConnectorAccess(Client client, Connector connector) {
        User user = RestActionUtils.getUserContext(client);
        if (this.isAdmin(user) || this.accessControlNotEnabled(user)) {
            return true;
        }
        return this.hasPermission(user, connector);
    }

    public void getConnector(Client client, String connectorId, ActionListener<Connector> listener) {
        GetRequest getRequest = ((GetRequest)new GetRequest().index(".plugins-ml-connector")).id(connectorId);
        client.get(getRequest, ActionListener.wrap(r -> {
            if (r != null && r.isExists()) {
                try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(NamedXContentRegistry.EMPTY, r.getSourceAsBytesRef());){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    Connector connector = Connector.createConnector((XContentParser)parser);
                    listener.onResponse((Object)connector);
                }
                catch (Exception e) {
                    log.error("Failed to parse connector:{}", (Object)connectorId);
                    listener.onFailure(e);
                }
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException("Failed to find connector:" + connectorId, RestStatus.NOT_FOUND, new Object[0]));
            }
        }, e -> {
            log.error("Failed to get connector", (Throwable)e);
            listener.onFailure((Exception)new OpenSearchStatusException("Failed to get connector:" + connectorId, RestStatus.NOT_FOUND, new Object[0]));
        }));
    }

    public void getConnector(SdkClient sdkClient, Client client, ThreadContext.StoredContext context, GetDataObjectRequest getDataObjectRequest, String connectorId, ActionListener<Connector> listener) {
        sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
            block15: {
                context.restore();
                log.debug("Completed Get Connector Request, id:{}", (Object)connectorId);
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    if (ExceptionsHelper.unwrap((Throwable)throwable, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                        log.error("Failed to get connector index", (Throwable)cause);
                        listener.onFailure((Exception)new OpenSearchStatusException("Failed to find connector", RestStatus.NOT_FOUND, new Object[0]));
                    } else {
                        log.error("Failed to get ML connector {}", (Object)connectorId, (Object)cause);
                        listener.onFailure(cause);
                    }
                } else {
                    try {
                        GetResponse gr;
                        GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                        if (gr != null && gr.isExists()) {
                            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                Connector mlConnector = Connector.createConnector((XContentParser)parser);
                                mlConnector.removeCredential();
                                listener.onResponse((Object)mlConnector);
                                break block15;
                            }
                            catch (Exception e) {
                                log.error("Failed to parse ml connector {}", (Object)r.id(), (Object)e);
                                listener.onFailure(e);
                            }
                            break block15;
                        }
                        listener.onFailure((Exception)new OpenSearchStatusException("Failed to find connector with the provided connector id: " + connectorId, RestStatus.NOT_FOUND, new Object[0]));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            }
        });
    }

    public boolean skipConnectorAccessControl(User user) {
        return user == null || this.connectorAccessControlEnabled == false || this.isAdmin(user);
    }

    public boolean accessControlNotEnabled(User user) {
        return user == null || this.connectorAccessControlEnabled == false;
    }

    public boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)user.getRoles())) {
            return false;
        }
        return user.getRoles().contains("all_access");
    }

    private boolean isOwner(User owner, User user) {
        if (user == null || owner == null) {
            return false;
        }
        return owner.getName().equals(user.getName());
    }

    private boolean isUserHasBackendRole(User user, Connector connector) {
        AccessMode modelAccessMode = connector.getAccess();
        return AccessMode.RESTRICTED == modelAccessMode && user.getBackendRoles() != null && connector.getBackendRoles() != null && connector.getBackendRoles().stream().anyMatch(x -> user.getBackendRoles().contains(x));
    }

    private boolean previouslyPublicConnector(Connector connector) {
        return connector.getOwner() == null;
    }

    private boolean isPublicConnector(Connector connector) {
        return AccessMode.PUBLIC == connector.getAccess();
    }

    private boolean isPrivateConnector(Connector connector) {
        return AccessMode.PRIVATE == connector.getAccess();
    }

    private boolean isRestrictedConnector(Connector connector) {
        return AccessMode.RESTRICTED == connector.getAccess();
    }

    public SearchSourceBuilder addUserBackendRolesFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"access", (String)AccessMode.PUBLIC.getValue()));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"backend_roles.keyword", (Collection)user.getBackendRoles()));
        BoolQueryBuilder privateBoolQuery = new BoolQueryBuilder();
        String ownerName = "owner.name.keyword";
        TermQueryBuilder ownerNameTermQuery = QueryBuilders.termQuery((String)ownerName, (String)user.getName());
        NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder("owner", (QueryBuilder)ownerNameTermQuery, ScoreMode.None);
        privateBoolQuery.must((QueryBuilder)nestedQueryBuilder);
        privateBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"access", (String)AccessMode.PRIVATE.getValue()));
        boolQueryBuilder.should((QueryBuilder)privateBoolQuery);
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (query instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)query).filter((QueryBuilder)boolQueryBuilder);
        } else {
            BoolQueryBuilder rewriteQuery = new BoolQueryBuilder();
            rewriteQuery.must(query);
            rewriteQuery.filter((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.query((QueryBuilder)rewriteQuery);
        }
        return searchSourceBuilder;
    }
}

