/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.models;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.transport.model.MLModelGetResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetModelTransportAction
extends HandledTransportAction<ActionRequest, MLModelGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetModelTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private Settings settings;

    @Inject
    public GetModelTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, Settings settings, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/models/get", transportService, actionFilters, MLModelGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGetResponse> actionListener) {
        MLModelGetRequest mlModelGetRequest = MLModelGetRequest.fromActionRequest((ActionRequest)request);
        String modelId = mlModelGetRequest.getModelId();
        String tenantId = mlModelGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlModelGetRequest.isReturnContent());
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-model")).id(modelId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block21: {
                    if (throwable == null) {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    String algorithmName = r.source().get("algorithm").toString();
                                    Boolean isHidden = (Boolean)r.source().get("is_hidden");
                                    MLModel mlModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                                    if (!TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlModel.getTenantId(), actionListener)) {
                                        return;
                                    }
                                    if (isHidden != null && isHidden.booleanValue()) {
                                        if (isSuperAdmin || !mlModelGetRequest.isUserInitiatedGetRequest()) {
                                            wrappedListener.onResponse((Object)MLModelGetResponse.builder().mlModel(mlModel).build());
                                        } else {
                                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                        }
                                    } else {
                                        this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                                            if (!access.booleanValue()) {
                                                wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                                            } else {
                                                log.debug("Completed Get Model Request, id:{}", (Object)modelId);
                                                Connector connector = mlModel.getConnector();
                                                if (connector != null) {
                                                    connector.removeCredential();
                                                }
                                                wrappedListener.onResponse((Object)MLModelGetResponse.builder().mlModel(mlModel).build());
                                            }
                                        }, e -> {
                                            log.error("Failed to validate Access for Model Id {}", (Object)modelId, e);
                                            wrappedListener.onFailure(e);
                                        }));
                                    }
                                    break block21;
                                }
                                catch (Exception e2) {
                                    log.error("Failed to parse ml model {}", (Object)r.id(), (Object)e2);
                                    wrappedListener.onFailure(e2);
                                }
                                break block21;
                            }
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model with the provided model id: " + modelId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e3) {
                            wrappedListener.onFailure(e3);
                        }
                    } else {
                        Exception e4 = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (ExceptionsHelper.unwrap((Throwable)e4, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Fail to find model", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML model {}", (Object)modelId, (Object)e4);
                            wrappedListener.onFailure(e4);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get ML model {}", (Object)modelId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

