/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupRequest;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupResponse;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelGroupManager;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportRegisterModelGroupAction
extends HandledTransportAction<ActionRequest, MLRegisterModelGroupResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterModelGroupAction.class);
    private final TransportService transportService;
    private final ActionFilters actionFilters;
    private final MLIndicesHandler mlIndicesHandler;
    private final ThreadPool threadPool;
    private final Client client;
    private final SdkClient sdkClient;
    ClusterService clusterService;
    ModelAccessControlHelper modelAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportRegisterModelGroupAction(TransportService transportService, ActionFilters actionFilters, MLIndicesHandler mlIndicesHandler, ThreadPool threadPool, Client client, SdkClient sdkClient, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/register_model_group", transportService, actionFilters, MLRegisterModelGroupRequest::new);
        this.transportService = transportService;
        this.actionFilters = actionFilters;
        this.mlIndicesHandler = mlIndicesHandler;
        this.threadPool = threadPool;
        this.client = client;
        this.sdkClient = sdkClient;
        this.clusterService = clusterService;
        this.mlModelGroupManager = mlModelGroupManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterModelGroupResponse> listener) {
        MLRegisterModelGroupRequest createModelGroupRequest = MLRegisterModelGroupRequest.fromActionRequest((ActionRequest)request);
        MLRegisterModelGroupInput createModelGroupInput = createModelGroupRequest.getRegisterModelGroupInput();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, createModelGroupInput.getTenantId(), listener)) {
            return;
        }
        this.mlModelGroupManager.createModelGroup(createModelGroupInput, (ActionListener<String>)ActionListener.wrap(modelGroupId -> listener.onResponse((Object)new MLRegisterModelGroupResponse(modelGroupId, MLTaskState.CREATED.name())), ex -> {
            log.error("Failed to init model group index", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }
}

