/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLUpdateConnectorRequest;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateConnectorTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateConnectorTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLModelManager mlModelManager;
    private final MLEngine mlEngine;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public UpdateConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, MLModelManager mlModelManager, Settings settings, ClusterService clusterService, MLEngine mlEngine, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/connectors/update", transportService, actionFilters, MLUpdateConnectorRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.mlEngine = mlEngine;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> listener) {
        MLUpdateConnectorRequest mlUpdateConnectorAction = MLUpdateConnectorRequest.fromActionRequest((ActionRequest)request);
        MLCreateConnectorInput mlCreateConnectorInput = mlUpdateConnectorAction.getUpdateContent();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, mlCreateConnectorInput.getTenantId(), listener)) {
            return;
        }
        String connectorId = mlUpdateConnectorAction.getConnectorId();
        String tenantId = mlCreateConnectorInput.getTenantId();
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.connectorAccessControlHelper.getConnector(this.sdkClient, this.client, context, getDataObjectRequest, connectorId, (ActionListener<Connector>)ActionListener.wrap(connector -> {
                if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, connector.getTenantId(), listener)) {
                    boolean hasPermission = this.connectorAccessControlHelper.validateConnectorAccess(this.client, (Connector)connector);
                    if (hasPermission) {
                        connector.update(mlUpdateConnectorAction.getUpdateContent(), (arg_0, arg_1) -> ((MLEngine)this.mlEngine).encrypt(arg_0, arg_1));
                        connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
                        connector.setLastUpdateTime(Instant.now());
                        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).dataObject((ToXContentObject)connector).build();
                        try (ThreadContext.StoredContext innerContext = this.client.threadPool().getThreadContext().stashContext();){
                            this.updateUndeployedConnector(connectorId, updateDataObjectRequest, (ActionListener<UpdateResponse>)ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)innerContext).restore()));
                        }
                    } else {
                        listener.onFailure((Exception)new IllegalArgumentException("You don't have permission to update the connector, connector id: " + connectorId));
                    }
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the connector with ID {}. Details: {}", (Object)connectorId, exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Failed to update ML connector for connector id {}. Details {}:", (Object)connectorId, (Object)e);
            listener.onFailure(e);
        }
    }

    private void updateUndeployedConnector(String connectorId, UpdateDataObjectRequest updateDataObjectRequest, ActionListener<UpdateResponse> listener) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"connector_id", (Object)connectorId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.idsQuery().addIds(this.mlModelManager.getAllModelIds()));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-model"}).tenantId(updateDataObjectRequest.tenantId()).searchSourceBuilder(sourceBuilder).build();
        this.sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete((sr, st) -> {
            block8: {
                if (sr != null) {
                    try {
                        SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)sr.parser());
                        SearchHit[] searchHits = searchResponse.getHits().getHits();
                        if (searchHits.length == 0) {
                            this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((r, throwable) -> this.handleUpdateDataObjectCompletionStage((UpdateDataObjectResponse)r, (Throwable)throwable, this.getUpdateResponseListener(connectorId, listener)));
                            break block8;
                        }
                        log.error("{} models are still using this connector, please undeploy the models first!", (Object)searchHits.length);
                        ArrayList<String> modelIds = new ArrayList<String>();
                        for (SearchHit hit : searchHits) {
                            modelIds.add(hit.getId());
                        }
                        listener.onFailure((Exception)new OpenSearchStatusException(searchHits.length + " models are still using this connector, please undeploy the models first: " + Arrays.toString(modelIds.toArray(new String[0])), RestStatus.BAD_REQUEST, new Object[0]));
                    }
                    catch (Exception e) {
                        log.error("Failed to parse search response", (Throwable)e);
                        listener.onFailure((Exception)new OpenSearchStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                } else {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)st, (Class[])new Class[0]);
                    if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                        this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((r, throwable) -> this.handleUpdateDataObjectCompletionStage((UpdateDataObjectResponse)r, (Throwable)throwable, this.getUpdateResponseListener(connectorId, listener)));
                    } else {
                        log.error("Failed to update ML connector: {}", (Object)connectorId, (Object)cause);
                        listener.onFailure(cause);
                    }
                }
            }
        });
    }

    private void handleUpdateDataObjectCompletionStage(UpdateDataObjectResponse r, Throwable throwable, ActionListener<UpdateResponse> updateListener) {
        if (throwable != null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            updateListener.onFailure(cause);
        } else {
            try {
                UpdateResponse updateResponse = r.parser() == null ? null : UpdateResponse.fromXContent((XContentParser)r.parser());
                updateListener.onResponse((Object)updateResponse);
            }
            catch (IOException e) {
                updateListener.onFailure((Exception)e);
            }
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String connectorId, ActionListener<UpdateResponse> actionListener) {
        return ActionListener.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.error("Failed to update the connector with ID: {}", (Object)connectorId);
                actionListener.onResponse(updateResponse);
                return;
            }
            log.info("Successfully updated the connector with ID: {}", (Object)connectorId);
            actionListener.onResponse(updateResponse);
        }, exception -> {
            log.error("Failed to update ML connector with ID {}. Details: {}", (Object)connectorId, exception);
            actionListener.onFailure(exception);
        });
    }
}

