/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteRequest;
import org.opensearch.ml.common.transport.connector.MLExecuteConnectorRequest;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.algorithms.remote.RemoteConnectorExecutor;
import org.opensearch.ml.engine.encryptor.EncryptorImpl;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.script.ScriptService;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class ExecuteConnectorTransportAction
extends HandledTransportAction<ActionRequest, MLTaskResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(ExecuteConnectorTransportAction.class);
    Client client;
    ClusterService clusterService;
    ScriptService scriptService;
    NamedXContentRegistry xContentRegistry;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    EncryptorImpl encryptor;

    @Inject
    public ExecuteConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, EncryptorImpl encryptor) {
        super("cluster:admin/opensearch/ml/connectors/execute", transportService, actionFilters, MLConnectorDeleteRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.encryptor = encryptor;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLTaskResponse> actionListener) {
        MLExecuteConnectorRequest executeConnectorRequest = MLExecuteConnectorRequest.fromActionRequest((ActionRequest)request);
        String connectorId = executeConnectorRequest.getConnectorId();
        String connectorAction = ConnectorAction.ActionType.EXECUTE.name();
        if (this.clusterService.state().metadata().hasIndex(".plugins-ml-connector")) {
            ActionListener listener = ActionListener.wrap(connector -> {
                if (this.connectorAccessControlHelper.validateConnectorAccess(this.client, (Connector)connector)) {
                    connector.decrypt(connectorAction, (credential, tenantId) -> this.encryptor.decrypt(credential, null), null);
                    RemoteConnectorExecutor connectorExecutor = (RemoteConnectorExecutor)MLEngineClassLoader.initInstance((Object)connector.getProtocol(), (Object)connector, Connector.class);
                    connectorExecutor.setScriptService(this.scriptService);
                    connectorExecutor.setClusterService(this.clusterService);
                    connectorExecutor.setClient(this.client);
                    connectorExecutor.setXContentRegistry(this.xContentRegistry);
                    connectorExecutor.executeAction(connectorAction, executeConnectorRequest.getMlInput(), ActionListener.wrap(taskResponse -> actionListener.onResponse(taskResponse), e -> actionListener.onFailure(e)));
                }
            }, e -> {
                log.error("Failed to get connector " + connectorId, (Throwable)e);
                actionListener.onFailure(e);
            });
            try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                this.connectorAccessControlHelper.getConnector(this.client, connectorId, (ActionListener<Connector>)ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)threadContext).restore()));
            }
        } else {
            actionListener.onFailure((Exception)new ResourceNotFoundException("Can't find connector " + connectorId, new Object[0]));
        }
    }
}

