/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteConnectorTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteConnectorTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/connectors/delete", transportService, actionFilters, MLConnectorDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLConnectorDeleteRequest mlConnectorDeleteRequest = MLConnectorDeleteRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlConnectorDeleteRequest.getConnectorId();
        String tenantId = mlConnectorDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        this.connectorAccessControlHelper.validateConnectorAccess(this.sdkClient, this.client, connectorId, tenantId, this.mlFeatureEnabledSetting, (ActionListener<Boolean>)ActionListener.wrap(isAllowed -> this.handleConnectorAccessValidation(connectorId, tenantId, (boolean)isAllowed, actionListener), e -> this.handleConnectorAccessValidationFailure(connectorId, (Exception)e, actionListener)));
    }

    private void handleConnectorAccessValidation(String connectorId, String tenantId, boolean isAllowed, ActionListener<DeleteResponse> actionListener) {
        if (isAllowed) {
            this.checkForModelsUsingConnector(connectorId, tenantId, actionListener);
        } else {
            actionListener.onFailure((Exception)new MLValidationException("You are not allowed to delete this connector"));
        }
    }

    private void handleConnectorAccessValidationFailure(String connectorId, Exception e, ActionListener<DeleteResponse> actionListener) {
        log.error("Failed to delete ML connector: {}", (Object)connectorId, (Object)e);
        actionListener.onFailure(e);
    }

    private void checkForModelsUsingConnector(String connectorId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoringListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            SearchDataObjectRequest searchRequest = this.buildModelSearchRequest(connectorId, tenantId);
            this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete((searchResponse, throwable) -> this.handleSearchResponse(connectorId, tenantId, (ActionListener<DeleteResponse>)restoringListener, (SearchDataObjectResponse)searchResponse, (Throwable)throwable));
        }
        catch (Exception e) {
            log.error("Failed to check for models using connector: {}", (Object)connectorId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private SearchDataObjectRequest buildModelSearchRequest(String connectorId, String tenantId) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"connector_id", (Object)connectorId));
        return SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-model"}).tenantId(tenantId).searchSourceBuilder(sourceBuilder).build();
    }

    private void handleSearchResponse(String connectorId, String tenantId, ActionListener<DeleteResponse> restoringListener, SearchDataObjectResponse searchResponse, Throwable throwable) {
        if (searchResponse == null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            this.handleSearchFailure(connectorId, tenantId, cause, restoringListener);
            return;
        }
        try {
            SearchResponse response = SearchResponse.fromXContent((XContentParser)searchResponse.parser());
            SearchHit[] searchHits = response.getHits().getHits();
            if (searchHits.length == 0) {
                this.deleteConnector(connectorId, tenantId, restoringListener);
            } else {
                this.handleModelsUsingConnector(searchHits, connectorId, restoringListener);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse search response", (Throwable)e);
            restoringListener.onFailure((Exception)new OpenSearchStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void handleModelsUsingConnector(SearchHit[] searchHits, String connectorId, ActionListener<DeleteResponse> actionListener) {
        log.error("{} models are still using this connector, please delete or update the models first!", (Object)searchHits.length);
        ArrayList<String> modelIds = new ArrayList<String>();
        for (SearchHit hit : searchHits) {
            modelIds.add(hit.getId());
        }
        actionListener.onFailure((Exception)new OpenSearchStatusException(searchHits.length + " models are still using this connector, please delete or update the models first: " + Arrays.toString(modelIds.toArray(new String[0])), RestStatus.CONFLICT, new Object[0]));
    }

    private void handleSearchFailure(String connectorId, String tenantId, Exception cause, ActionListener<DeleteResponse> actionListener) {
        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            this.deleteConnector(connectorId, tenantId, actionListener);
            return;
        }
        log.error("Failed to search for models using connector: {}", (Object)connectorId, (Object)cause);
        actionListener.onFailure(cause);
    }

    private void deleteConnector(String connectorId, String tenantId, ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-connector", connectorId);
        try {
            this.sdkClient.deleteDataObjectAsync(((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build()).whenComplete((response, throwable) -> this.handleDeleteResponse((DeleteDataObjectResponse)response, (Throwable)throwable, connectorId, actionListener));
        }
        catch (Exception e) {
            log.error("Failed to delete ML connector: {}", (Object)connectorId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String connectorId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML connector: {}", (Object)connectorId, (Object)cause);
            actionListener.onFailure(cause);
        } else {
            try {
                DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)response.parser());
                log.info("Connector deletion result: {}, connector id: {}", (Object)deleteResponse.getResult(), (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (IOException e) {
                actionListener.onFailure((Exception)e);
            }
        }
    }
}

