/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.config;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLConfig;
import org.opensearch.ml.common.transport.config.MLConfigGetRequest;
import org.opensearch.ml.common.transport.config.MLConfigGetResponse;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetConfigTransportAction
extends HandledTransportAction<ActionRequest, MLConfigGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetConfigTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetConfigTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/config/get", transportService, actionFilters, MLConfigGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLConfigGetResponse> actionListener) {
        MLConfigGetRequest mlConfigGetRequest = MLConfigGetRequest.fromActionRequest((ActionRequest)request);
        String configId = mlConfigGetRequest.getConfigId();
        String tenantId = mlConfigGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        GetRequest getRequest = new GetRequest(".plugins-ml-config").id(configId);
        if (configId.equals("master_key")) {
            actionListener.onFailure((Exception)new OpenSearchStatusException("You are not allowed to access this config doc", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(r -> {
                log.debug("Completed Get Agent Request, id:{}", (Object)configId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLConfig mlConfig = MLConfig.parse((XContentParser)parser);
                        actionListener.onResponse((Object)MLConfigGetResponse.builder().mlConfig(mlConfig).build());
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml config{}", (Object)r.getId(), (Object)e);
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find config with the provided config id: " + configId, RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    log.error("Failed to get agent index", (Throwable)e);
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to get config index", RestStatus.NOT_FOUND, new Object[0]));
                } else {
                    log.error("Failed to get ML config {}", (Object)configId, e);
                    actionListener.onFailure(e);
                }
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to get ML config {}", (Object)configId, (Object)e2);
            actionListener.onFailure(e2);
        }
    }
}

