/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.DeleteRuleRequest;
import org.opensearch.securityanalytics.action.DeleteRuleResponse;
import org.opensearch.securityanalytics.action.IndexDetectorAction;
import org.opensearch.securityanalytics.action.IndexDetectorRequest;
import org.opensearch.securityanalytics.action.IndexDetectorResponse;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.DetectorRule;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.transport.TransportDeleteDetectorAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

public class TransportDeleteRuleAction
extends HandledTransportAction<DeleteRuleRequest, DeleteRuleResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeleteDetectorAction.class);
    private final Client client;
    private final DetectorIndices detectorIndices;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;

    @Inject
    public TransportDeleteRuleAction(TransportService transportService, Client client, DetectorIndices detectorIndices, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/securityanalytics/rule/delete", transportService, actionFilters, DeleteRuleRequest::new);
        this.client = client;
        this.detectorIndices = detectorIndices;
        this.xContentRegistry = xContentRegistry;
        this.threadPool = client.threadPool();
    }

    protected void doExecute(Task task, DeleteRuleRequest request, ActionListener<DeleteRuleResponse> listener) {
        AsyncDeleteRuleAction asyncAction = new AsyncDeleteRuleAction(task, request, listener);
        asyncAction.start();
    }

    class AsyncDeleteRuleAction {
        private final DeleteRuleRequest request;
        private final ActionListener<DeleteRuleResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final AtomicInteger checker = new AtomicInteger();
        private final Task task;

        AsyncDeleteRuleAction(Task task, DeleteRuleRequest request, ActionListener<DeleteRuleResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            final String ruleId = this.request.getRuleId();
            GetRequest getRequest = new GetRequest(".opensearch-sap-custom-rules-config", ruleId);
            TransportDeleteRuleAction.this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        AsyncDeleteRuleAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with %s is not found", ruleId), RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    try {
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportDeleteRuleAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)XContentType.JSON);
                        Rule rule = Rule.docParse(xcp, response.getId(), response.getVersion());
                        AsyncDeleteRuleAction.this.onGetResponse(rule);
                    }
                    catch (IOException e) {
                        AsyncDeleteRuleAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncDeleteRuleAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with %s is not found", ruleId), RestStatus.NOT_FOUND, new Object[0]));
                }
            });
        }

        private void onGetResponse(final Rule rule) {
            if (TransportDeleteRuleAction.this.detectorIndices.detectorIndexExists()) {
                NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector.inputs.detector_input.custom_rules", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.inputs.detector_input.custom_rules.id", (Object)rule.getId())), (ScoreMode)ScoreMode.Avg);
                SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-detectors-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(10000)).preference(Preference.PRIMARY_FIRST.type());
                TransportDeleteRuleAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            AsyncDeleteRuleAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Search request timed out. Rule with id %s cannot be deleted", rule.getId()), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                            return;
                        }
                        if (response.getHits().getTotalHits().value() > 0L) {
                            if (!AsyncDeleteRuleAction.this.request.isForced().booleanValue()) {
                                AsyncDeleteRuleAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with id %s is actively used by detectors. Deletion can be forced by setting forced flag to true", rule.getId()), RestStatus.BAD_REQUEST, new Object[0]));
                                return;
                            }
                            ArrayList<Detector> detectors = new ArrayList<Detector>();
                            try {
                                for (SearchHit hit : response.getHits()) {
                                    XContentParser xcp = XContentType.JSON.xContent().createParser(TransportDeleteRuleAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                                    Detector detector = Detector.docParse(xcp, hit.getId(), hit.getVersion());
                                    if (!detector.getInputs().isEmpty()) {
                                        detector.getInputs().get(0).setCustomRules(AsyncDeleteRuleAction.this.removeRuleFromDetectors(detector, rule.getId()));
                                    }
                                    detectors.add(detector);
                                }
                            }
                            catch (IOException ex) {
                                AsyncDeleteRuleAction.this.onFailures(ex);
                            }
                            AsyncDeleteRuleAction.this.updateDetectors(detectors);
                        } else {
                            AsyncDeleteRuleAction.this.deleteRule(rule.getId());
                        }
                    }

                    public void onFailure(Exception e) {
                        AsyncDeleteRuleAction.this.onFailures(e);
                    }
                });
            } else {
                this.deleteRule(rule.getId());
            }
        }

        private void updateDetectors(final List<Detector> detectors) {
            for (Detector detector : detectors) {
                IndexDetectorRequest indexRequest = new IndexDetectorRequest(detector.getId(), this.request.getRefreshPolicy(), RestRequest.Method.PUT, detector);
                TransportDeleteRuleAction.this.client.execute((ActionType)IndexDetectorAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexDetectorResponse>(){

                    public void onResponse(IndexDetectorResponse response) {
                        if (response.getStatus() != RestStatus.OK) {
                            AsyncDeleteRuleAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Rule with id %s cannot be deleted", AsyncDeleteRuleAction.this.request.getRuleId()), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                        AsyncDeleteRuleAction.this.onComplete(AsyncDeleteRuleAction.this.request.getRuleId(), detectors.size());
                    }

                    public void onFailure(Exception e) {
                        AsyncDeleteRuleAction.this.onFailures(e);
                    }
                });
            }
        }

        private void onComplete(String ruleId, int target) {
            if (this.checker.incrementAndGet() == target) {
                this.deleteRule(ruleId);
            }
        }

        private void deleteRule(final String ruleId) {
            ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)TransportDeleteRuleAction.this.client, (ActionType)DeleteByQueryAction.INSTANCE).source(new String[]{".opensearch-sap-custom-rules-config"})).filter((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)ruleId))).refresh(true)).execute((ActionListener)new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse response) {
                    if (response.isTimedOut()) {
                        AsyncDeleteRuleAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Request timed out. Rule with id %s cannot be deleted", ruleId), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                        return;
                    }
                    AsyncDeleteRuleAction.this.onOperation(response, ruleId);
                }

                public void onFailure(Exception e) {
                    AsyncDeleteRuleAction.this.onFailures(e);
                }
            });
        }

        private List<DetectorRule> removeRuleFromDetectors(Detector detector, String ruleId) {
            ArrayList<DetectorRule> newRules = new ArrayList<DetectorRule>();
            if (!detector.getInputs().isEmpty()) {
                List<DetectorRule> rules = detector.getInputs().get(0).getCustomRules();
                for (DetectorRule rule : rules) {
                    if (rule.getId().equals(ruleId)) continue;
                    newRules.add(rule);
                }
            }
            return newRules;
        }

        private void onOperation(BulkByScrollResponse response, String ruleId) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(ruleId, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(String ruleId, Exception t) {
            TransportDeleteRuleAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new DeleteRuleResponse(ruleId, Detector.NO_VERSION, RestStatus.NO_CONTENT);
            }));
        }
    }
}

