/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.SetOnce;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.DeleteMonitorRequest;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.commons.alerting.action.DeleteWorkflowResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.securityanalytics.action.DeleteDetectorRequest;
import org.opensearch.securityanalytics.action.DeleteDetectorResponse;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.ExceptionChecker;
import org.opensearch.securityanalytics.util.MonitorService;
import org.opensearch.securityanalytics.util.RuleTopicIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.securityanalytics.util.ThrowableCheckingPredicates;
import org.opensearch.securityanalytics.util.WorkflowService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

public class TransportDeleteDetectorAction
extends HandledTransportAction<DeleteDetectorRequest, DeleteDetectorResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeleteDetectorAction.class);
    private static final List<ThrowableCheckingPredicates> ACCEPTABLE_ENTITY_MISSING_THROWABLE_MATCHERS = List.of(ThrowableCheckingPredicates.MONITOR_NOT_FOUND, ThrowableCheckingPredicates.WORKFLOW_NOT_FOUND, ThrowableCheckingPredicates.ALERTING_CONFIG_INDEX_NOT_FOUND);
    private final Client client;
    private final RuleTopicIndices ruleTopicIndices;
    private final NamedXContentRegistry xContentRegistry;
    private final WorkflowService workflowService;
    private final MonitorService monitorService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final ClusterService clusterService;
    private volatile Boolean enabledWorkflowUsage;
    private final IndexTemplateManager indexTemplateManager;
    private final DetectorIndices detectorIndices;
    private final ExceptionChecker exceptionChecker;

    @Inject
    public TransportDeleteDetectorAction(TransportService transportService, IndexTemplateManager indexTemplateManager, Client client, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, RuleTopicIndices ruleTopicIndices, DetectorIndices detectorIndices, ClusterService clusterService, Settings settings, ExceptionChecker exceptionChecker) {
        super("cluster:admin/opensearch/securityanalytics/detector/delete", transportService, actionFilters, DeleteDetectorRequest::new);
        this.client = client;
        this.ruleTopicIndices = ruleTopicIndices;
        this.xContentRegistry = xContentRegistry;
        this.threadPool = client.threadPool();
        this.indexTemplateManager = indexTemplateManager;
        this.detectorIndices = detectorIndices;
        this.monitorService = new MonitorService(client);
        this.workflowService = new WorkflowService(client, this.monitorService);
        this.clusterService = clusterService;
        this.settings = settings;
        this.enabledWorkflowUsage = (Boolean)SecurityAnalyticsSettings.ENABLE_WORKFLOW_USAGE.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ENABLE_WORKFLOW_USAGE, this::setEnabledWorkflowUsage);
        this.exceptionChecker = exceptionChecker;
    }

    protected void doExecute(Task task, DeleteDetectorRequest request, ActionListener<DeleteDetectorResponse> listener) {
        AsyncDeleteDetectorAction asyncAction = new AsyncDeleteDetectorAction(task, request, listener, this.detectorIndices);
        asyncAction.start();
    }

    private void deleteAlertingMonitor(String monitorId, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteMonitorResponse> listener) {
        DeleteMonitorRequest request = new DeleteMonitorRequest(monitorId, refreshPolicy);
        AlertingPluginInterface.INSTANCE.deleteMonitor((NodeClient)this.client, request, listener);
    }

    private void deleteDetector(String detectorId, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<DeleteResponse> listener) {
        DeleteRequest request = (DeleteRequest)new DeleteRequest(".opensearch-sap-detectors-config", detectorId).setRefreshPolicy(refreshPolicy);
        this.client.delete(request, listener);
    }

    private void logAcceptableEntityMissingException(Exception e, String detectorId) {
        String errorMsg = String.format(Locale.ROOT, "Workflow, monitor, or jobs index already deleted. Proceeding with detector %s deletion", detectorId);
        log.error(errorMsg, (Throwable)e);
    }

    private void setEnabledWorkflowUsage(boolean enabledWorkflowUsage) {
        this.enabledWorkflowUsage = enabledWorkflowUsage;
    }

    class AsyncDeleteDetectorAction {
        private final DeleteDetectorRequest request;
        private final ActionListener<DeleteDetectorResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final DetectorIndices detectorIndices;
        private final Task task;

        AsyncDeleteDetectorAction(Task task, DeleteDetectorRequest request, ActionListener<DeleteDetectorResponse> listener, DetectorIndices detectorIndices) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
            this.detectorIndices = detectorIndices;
        }

        void start() {
            if (!this.detectorIndices.detectorIndexExists()) {
                this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", this.request.getDetectorId()), RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            TransportDeleteDetectorAction.this.threadPool.getThreadContext().stashContext();
            final String detectorId = this.request.getDetectorId();
            GetRequest getRequest = new GetRequest(".opensearch-sap-detectors-config", detectorId);
            TransportDeleteDetectorAction.this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        AsyncDeleteDetectorAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", detectorId), RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    try {
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportDeleteDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)XContentType.JSON);
                        Detector detector = Detector.docParse(xcp, response.getId(), response.getVersion());
                        AsyncDeleteDetectorAction.this.onGetResponse(detector);
                    }
                    catch (Exception e) {
                        AsyncDeleteDetectorAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception t) {
                    AsyncDeleteDetectorAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", detectorId), RestStatus.NOT_FOUND, new Object[0]));
                }
            });
        }

        private void onGetResponse(final Detector detector) {
            StepListener onDeleteWorkflowStep = new StepListener();
            this.deleteWorkflow(detector, (ActionListener<AcknowledgedResponse>)onDeleteWorkflowStep);
            onDeleteWorkflowStep.whenComplete(acknowledgedResponse -> {
                List<String> monitorIds = detector.getMonitorIds();
                GroupedActionListener deletesListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<DeleteMonitorResponse>>(){

                    public void onResponse(Collection<DeleteMonitorResponse> responses) {
                        SetOnce errorStatusSupplier = new SetOnce();
                        if (responses.stream().filter(response -> {
                            if (response.getStatus() != RestStatus.OK) {
                                log.error("Detector not being deleted because monitor [{}] could not be deleted. Status [{}]", (Object)response.getId(), (Object)response.getStatus());
                                errorStatusSupplier.trySet((Object)response.getStatus());
                                return true;
                            }
                            return false;
                        }).count() > 0L) {
                            AsyncDeleteDetectorAction.this.onFailures((Exception)new OpenSearchStatusException("Monitor associated with detected could not be deleted", (RestStatus)errorStatusSupplier.get(), new Object[0]));
                        }
                        AsyncDeleteDetectorAction.this.deleteDetectorFromConfig(detector.getId(), AsyncDeleteDetectorAction.this.request.getRefreshPolicy());
                    }

                    public void onFailure(Exception e) {
                        if (TransportDeleteDetectorAction.this.exceptionChecker.doesGroupedActionListenerExceptionMatch(e, ACCEPTABLE_ENTITY_MISSING_THROWABLE_MATCHERS)) {
                            TransportDeleteDetectorAction.this.logAcceptableEntityMissingException(e, detector.getId());
                            AsyncDeleteDetectorAction.this.deleteDetectorFromConfig(detector.getId(), AsyncDeleteDetectorAction.this.request.getRefreshPolicy());
                        } else {
                            log.error(String.format(Locale.ROOT, "Failed to delete detector %s", detector.getId()), (Throwable)e);
                            if (AsyncDeleteDetectorAction.this.counter.compareAndSet(false, true)) {
                                AsyncDeleteDetectorAction.this.finishHim(null, e);
                            }
                        }
                    }
                }, monitorIds.size());
                for (String monitorId : monitorIds) {
                    TransportDeleteDetectorAction.this.deleteAlertingMonitor(monitorId, this.request.getRefreshPolicy(), (ActionListener<DeleteMonitorResponse>)deletesListener);
                }
            }, e -> {
                if (this.counter.compareAndSet(false, true)) {
                    this.finishHim(null, (Exception)e);
                }
            });
        }

        private void deleteWorkflow(Detector detector, ActionListener<AcknowledgedResponse> actionListener) {
            if (detector.isWorkflowSupported() && TransportDeleteDetectorAction.this.enabledWorkflowUsage.booleanValue()) {
                String workflowId = detector.getWorkflowIds().get(0);
                log.debug(String.format("Deleting the workflow %s before deleting the detector", workflowId));
                StepListener onDeleteWorkflowStep = new StepListener();
                TransportDeleteDetectorAction.this.workflowService.deleteWorkflow(workflowId, (ActionListener<DeleteWorkflowResponse>)onDeleteWorkflowStep);
                onDeleteWorkflowStep.whenComplete(deleteWorkflowResponse -> actionListener.onResponse((Object)new AcknowledgedResponse(true)), deleteWorkflowResponse -> this.handleDeleteWorkflowFailure(detector.getId(), (Exception)deleteWorkflowResponse, actionListener));
            } else {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }

        private void handleDeleteWorkflowFailure(String detectorId, Exception deleteWorkflowException, ActionListener<AcknowledgedResponse> actionListener) {
            if (TransportDeleteDetectorAction.this.exceptionChecker.doesGroupedActionListenerExceptionMatch(deleteWorkflowException, ACCEPTABLE_ENTITY_MISSING_THROWABLE_MATCHERS)) {
                TransportDeleteDetectorAction.this.logAcceptableEntityMissingException(deleteWorkflowException, detectorId);
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                actionListener.onFailure(deleteWorkflowException);
            }
        }

        private void deleteDetectorFromConfig(String detectorId, WriteRequest.RefreshPolicy refreshPolicy) {
            TransportDeleteDetectorAction.this.deleteDetector(detectorId, refreshPolicy, new ActionListener<DeleteResponse>(){

                public void onResponse(final DeleteResponse response) {
                    TransportDeleteDetectorAction.this.indexTemplateManager.deleteAllUnusedTemplates(new ActionListener<Void>(){

                        public void onResponse(Void unused) {
                            AsyncDeleteDetectorAction.this.onOperation(response);
                        }

                        public void onFailure(Exception e) {
                            log.error("Error deleting unused templates: " + e.getMessage());
                            AsyncDeleteDetectorAction.this.onOperation(response);
                        }
                    });
                }

                public void onFailure(Exception t) {
                    AsyncDeleteDetectorAction.this.onFailures(t);
                }
            });
        }

        private void onOperation(DeleteResponse response) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response.getId(), null);
            }
        }

        private void onFailures(Exception t) {
            log.error(String.format(Locale.ROOT, "Failed to delete detector", new Object[0]));
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(String detectorId, Exception t) {
            TransportDeleteDetectorAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    log.error(String.format(Locale.ROOT, "Failed to delete detector %s", detectorId), (Throwable)t);
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new DeleteDetectorResponse(detectorId, Detector.NO_VERSION, RestStatus.NO_CONTENT);
            }));
        }
    }
}

