/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.intel.qat.QatZipper;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.lucene101.Lucene101Codec;
import org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.opensearch.index.codec.customcodecs.Lucene101QatStoredFieldsFormat;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99QatCodec;
import org.opensearch.index.mapper.MapperService;

public abstract class Lucene101QatCodec
extends FilterCodec {
    public static final Mode DEFAULT_COMPRESSION_MODE = Mode.QAT_LZ4;
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene101QatCodec(Mode mode) {
        this(mode, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene101QatCodec(Mode mode, int compressionLevel) {
        super(mode.getCodec(), (Codec)new Lucene101Codec());
        this.storedFieldsFormat = new Lucene101QatStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene101QatCodec(Mode mode, int compressionLevel, Supplier<QatZipper.Mode> supplier) {
        super(mode.getCodec(), (Codec)new Lucene101Codec());
        this.storedFieldsFormat = new Lucene101QatStoredFieldsFormat(mode, compressionLevel, supplier);
    }

    public Lucene101QatCodec(Mode mode, int compressionLevel, MapperService mapperService, Logger logger) {
        super(mode.getCodec(), (Codec)new PerFieldMappingPostingFormatCodec(Lucene101Codec.Mode.BEST_SPEED, mapperService, logger));
        this.storedFieldsFormat = new Lucene101QatStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene101QatCodec(Mode mode, int compressionLevel, MapperService mapperService, Logger logger, Supplier<QatZipper.Mode> supplier) {
        super(mode.getCodec(), (Codec)new PerFieldMappingPostingFormatCodec(Lucene101Codec.Mode.BEST_SPEED, mapperService, logger));
        this.storedFieldsFormat = new Lucene101QatStoredFieldsFormat(mode, compressionLevel, supplier);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static enum Mode {
        QAT_LZ4("QATLZ4101", Set.of("qat_lz4")),
        QAT_DEFLATE("QATDEFLATE101", Set.of("qat_deflate"));

        private final String codec;
        private final Set<String> aliases;

        private Mode(String codec, Set<String> aliases) {
            this.codec = codec;
            this.aliases = aliases;
        }

        public String getCodec() {
            return this.codec;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

