/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.opensearch.knn.memoryoptsearch.faiss.AbstractFaissHNSWIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSWIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndex;
import org.opensearch.knn.memoryoptsearch.faiss.MonotonicIntegerSequenceEncoder;

public class FaissIdMapIndex
extends FaissIndex {
    public static final String IXMP = "IxMp";
    private AbstractFaissHNSWIndex nestedIndex;
    private DirectMonotonicReader idMappingReader;

    public FaissIdMapIndex() {
        super(IXMP);
    }

    @Override
    protected void doLoad(IndexInput input) throws IOException {
        AbstractFaissHNSWIndex nestedHnswIndex;
        this.readCommonHeader(input);
        FaissIndex nestedIndex = FaissIndex.load(input);
        if (!(nestedIndex instanceof AbstractFaissHNSWIndex)) {
            throw new IllegalStateException("Invalid nested index. Expected " + FaissHNSWIndex.class.getSimpleName() + " , but got " + nestedIndex.getIndexType());
        }
        this.nestedIndex = nestedHnswIndex = (AbstractFaissHNSWIndex)nestedIndex;
        int numElements = Math.toIntExact(input.readLong());
        this.idMappingReader = MonotonicIntegerSequenceEncoder.encode(numElements, input);
    }

    @Override
    public VectorEncoding getVectorEncoding() {
        return this.nestedIndex.getVectorEncoding();
    }

    @Override
    public String getIndexType() {
        return IXMP;
    }

    @Override
    public FloatVectorValues getFloatValues(IndexInput indexInput) throws IOException {
        if (this.idMappingReader == null) {
            return this.nestedIndex.getFloatValues(indexInput);
        }
        return this.sparseFloatValues(indexInput);
    }

    @Override
    public ByteVectorValues getByteValues(IndexInput indexInput) throws IOException {
        if (this.idMappingReader == null) {
            return this.nestedIndex.getByteValues(indexInput);
        }
        return this.sparseByteValues(indexInput);
    }

    private ByteVectorValues sparseByteValues(IndexInput indexInput) throws IOException {
        ByteVectorValues vectorValues = this.nestedIndex.getByteValues(indexInput);
        class SparseByteVectorValuesImpl
        extends ByteVectorValues {
            private final ByteVectorValues vectorValues;

            public byte[] vectorValue(int internalVectorId) throws IOException {
                return this.vectorValues.vectorValue(internalVectorId);
            }

            public int dimension() {
                return this.vectorValues.dimension();
            }

            public int ordToDoc(int internalVectorId) {
                return (int)FaissIdMapIndex.this.idMappingReader.get((long)internalVectorId);
            }

            public Bits getAcceptOrds(Bits acceptDocs) {
                if (acceptDocs != null) {
                    final Bits internalBits = this.vectorValues.getAcceptOrds(acceptDocs);
                    return new Bits(){

                        public boolean get(int internalVectorId) {
                            return internalBits.get((int)FaissIdMapIndex.this.idMappingReader.get((long)internalVectorId));
                        }

                        public int length() {
                            return internalBits.length();
                        }
                    };
                }
                return null;
            }

            public int size() {
                return this.vectorValues.size();
            }

            public ByteVectorValues copy() throws IOException {
                return new SparseByteVectorValuesImpl(this.vectorValues.copy());
            }

            @Generated
            public SparseByteVectorValuesImpl(ByteVectorValues vectorValues) {
                this.vectorValues = vectorValues;
            }
        }
        return new SparseByteVectorValuesImpl(vectorValues);
    }

    private FloatVectorValues sparseFloatValues(IndexInput indexInput) throws IOException {
        FloatVectorValues vectorValues = this.nestedIndex.getFloatValues(indexInput);
        class SparseFloatVectorValuesImpl
        extends FloatVectorValues {
            private final FloatVectorValues vectorValues;

            public float[] vectorValue(int internalVectorId) throws IOException {
                return this.vectorValues.vectorValue(internalVectorId);
            }

            public int dimension() {
                return this.vectorValues.dimension();
            }

            public int ordToDoc(int internalVectorId) {
                return (int)FaissIdMapIndex.this.idMappingReader.get((long)internalVectorId);
            }

            public Bits getAcceptOrds(Bits acceptDocs) {
                if (acceptDocs != null) {
                    final Bits internalBits = this.vectorValues.getAcceptOrds(acceptDocs);
                    return new Bits(){

                        public boolean get(int internalVectorId) {
                            return internalBits.get((int)FaissIdMapIndex.this.idMappingReader.get((long)internalVectorId));
                        }

                        public int length() {
                            return internalBits.length();
                        }
                    };
                }
                return null;
            }

            public int size() {
                return this.vectorValues.size();
            }

            public FloatVectorValues copy() throws IOException {
                return new SparseFloatVectorValuesImpl(this.vectorValues.copy());
            }

            @Generated
            public SparseFloatVectorValuesImpl(FloatVectorValues vectorValues) {
                this.vectorValues = vectorValues;
            }
        }
        return new SparseFloatVectorValuesImpl(vectorValues);
    }

    @Generated
    public AbstractFaissHNSWIndex getNestedIndex() {
        return this.nestedIndex;
    }
}

