/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.faiss.AbstractFaissHNSWIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSW;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndex;

public class FaissHNSWIndex
extends AbstractFaissHNSWIndex {
    public static final String IHNF = "IHNf";
    public static final String IHNS = "IHNs";

    public FaissHNSWIndex(String indexType) {
        super(indexType, new FaissHNSW());
        if (!indexType.equals(IHNF) && !indexType.equals(IHNS)) {
            throw new IllegalStateException("Unsupported index type: [" + indexType + "] in " + FaissHNSWIndex.class.getSimpleName());
        }
    }

    @Override
    protected void doLoad(IndexInput input) throws IOException {
        this.readCommonHeader(input);
        this.hnsw.load(input, this.getTotalNumberOfVectors());
        this.flatVectors = FaissIndex.load(input);
    }

    @Override
    public VectorEncoding getVectorEncoding() {
        return this.flatVectors.getVectorEncoding();
    }

    @Override
    public FloatVectorValues getFloatValues(IndexInput indexInput) throws IOException {
        return this.flatVectors.getFloatValues(indexInput);
    }

    @Override
    public ByteVectorValues getByteValues(IndexInput indexInput) throws IOException {
        return this.flatVectors.getByteValues(indexInput);
    }
}

