/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;

public class MemoryOptimizedSearchSupportSpec {
    private static final Set<String> SUPPORTED_HNSW_ENCODING = Set.of("flat", "sq");

    public static boolean supported(Optional<KNNMethodContext> methodContextOpt, QuantizationConfig quantizationConfig, VectorDataType vectorDataType) {
        if (methodContextOpt.isPresent()) {
            KNNMethodContext methodContext = methodContextOpt.get();
            KNNEngine engine = methodContext.getKnnEngine();
            if (engine == KNNEngine.LUCENE) {
                return true;
            }
            if (engine != KNNEngine.FAISS) {
                return false;
            }
            MethodComponentContext methodComponentContext = methodContext.getMethodComponentContext();
            if (!methodComponentContext.getName().equals("hnsw")) {
                return false;
            }
            if (quantizationConfig != null && quantizationConfig.getQuantizationType() != null) {
                return false;
            }
            if (vectorDataType != VectorDataType.FLOAT && vectorDataType != VectorDataType.BYTE) {
                return false;
            }
            if (methodContext.getSpaceType() != SpaceType.L2 && methodContext.getSpaceType() != SpaceType.INNER_PRODUCT) {
                return false;
            }
            Map<String, Object> parameters = methodComponentContext.getParameters();
            Object methodComponentContextObj = parameters.get("encoder");
            if (!(methodComponentContextObj instanceof MethodComponentContext)) {
                return false;
            }
            return SUPPORTED_HNSW_ENCODING.contains(((MethodComponentContext)methodComponentContextObj).getName());
        }
        return false;
    }
}

