/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex.remote;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.StopWatch;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.plugin.stats.KNNRemoteIndexBuildValue;

public class RemoteIndexBuildMetrics {
    @Generated
    private static final Logger log = LogManager.getLogger(RemoteIndexBuildMetrics.class);
    private final StopWatch overallStopWatch = new StopWatch();
    private final StopWatch writeStopWatch = new StopWatch();
    private final StopWatch buildRequestStopWatch = new StopWatch();
    private final StopWatch waiterStopWatch = new StopWatch();
    private final StopWatch readStopWatch = new StopWatch();
    private long size;
    private boolean isFlush;
    private String fieldName;

    public void startRemoteIndexBuildMetrics(BuildIndexParams indexInfo) throws IOException {
        KNNVectorValues<?> knnVectorValues = indexInfo.getKnnVectorValuesSupplier().get();
        KNNCodecUtil.initializeVectorValues(knnVectorValues);
        this.size = (long)indexInfo.getTotalLiveDocs() * (long)knnVectorValues.bytesPerVector();
        this.isFlush = indexInfo.isFlush();
        this.fieldName = indexInfo.getFieldName();
        this.overallStopWatch.start();
        if (this.isFlush) {
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_OPERATIONS.increment();
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_SIZE.incrementBy(this.size);
        } else {
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_OPERATIONS.increment();
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_SIZE.incrementBy(this.size);
        }
    }

    public void startRepositoryWriteMetrics() {
        this.writeStopWatch.start();
    }

    public void endRepositoryWriteMetrics(boolean success) {
        long time_in_millis = this.writeStopWatch.stop().totalTime().millis();
        if (success) {
            KNNRemoteIndexBuildValue.WRITE_SUCCESS_COUNT.increment();
            KNNRemoteIndexBuildValue.WRITE_TIME.incrementBy(time_in_millis);
            log.debug("Repository write took {} ms for vector field [{}]", (Object)time_in_millis, (Object)this.fieldName);
        } else {
            KNNRemoteIndexBuildValue.WRITE_FAILURE_COUNT.increment();
        }
    }

    public void startBuildRequestMetrics() {
        this.buildRequestStopWatch.start();
    }

    public void endBuildRequestMetrics(boolean success) {
        long time_in_millis = this.buildRequestStopWatch.stop().totalTime().millis();
        if (success) {
            KNNRemoteIndexBuildValue.BUILD_REQUEST_SUCCESS_COUNT.increment();
            log.debug("Submit vector build took {} ms for vector field [{}]", (Object)time_in_millis, (Object)this.fieldName);
        } else {
            KNNRemoteIndexBuildValue.BUILD_REQUEST_FAILURE_COUNT.increment();
        }
    }

    public void startWaitingMetrics() {
        this.waiterStopWatch.start();
    }

    public void endWaitingMetrics() {
        long time_in_millis = this.waiterStopWatch.stop().totalTime().millis();
        KNNRemoteIndexBuildValue.WAITING_TIME.incrementBy(time_in_millis);
        log.debug("Await vector build took {} ms for vector field [{}]", (Object)time_in_millis, (Object)this.fieldName);
    }

    public void startRepositoryReadMetrics() {
        this.readStopWatch.start();
    }

    public void endRepositoryReadMetrics(boolean success) {
        long time_in_millis = this.readStopWatch.stop().totalTime().millis();
        if (success) {
            KNNRemoteIndexBuildValue.READ_SUCCESS_COUNT.increment();
            KNNRemoteIndexBuildValue.READ_TIME.incrementBy(time_in_millis);
            log.debug("Repository read took {} ms for vector field [{}]", (Object)time_in_millis, (Object)this.fieldName);
        } else {
            KNNRemoteIndexBuildValue.READ_FAILURE_COUNT.increment();
        }
    }

    public void endRemoteIndexBuildMetrics(boolean wasSuccessful) {
        long time_in_millis = this.overallStopWatch.stop().totalTime().millis();
        if (wasSuccessful) {
            KNNRemoteIndexBuildValue.INDEX_BUILD_SUCCESS_COUNT.increment();
            log.debug("Remote index build succeeded after {} ms for vector field [{}]", (Object)time_in_millis, (Object)this.fieldName);
        } else {
            KNNRemoteIndexBuildValue.INDEX_BUILD_FAILURE_COUNT.increment();
            log.warn("Remote index build failed after {} ms for vector field [{}]", (Object)time_in_millis, (Object)this.fieldName);
        }
        if (this.isFlush) {
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_OPERATIONS.decrement();
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_SIZE.decrementBy(this.size);
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_FLUSH_TIME.incrementBy(time_in_millis);
        } else {
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_OPERATIONS.decrement();
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_SIZE.decrementBy(this.size);
            KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_MERGE_TIME.incrementBy(time_in_millis);
        }
    }
}

