/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;

public class KNN9120BinaryVectorScorer
implements FlatVectorsScorer {
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues randomAccessVectorValues) throws IOException {
        if (randomAccessVectorValues instanceof ByteVectorValues) {
            return new BinaryRandomVectorScorerSupplier((ByteVectorValues)randomAccessVectorValues);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Bytes");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues randomAccessVectorValues, float[] queryVector) throws IOException {
        throw new IllegalArgumentException("binary vectors do not support float[] targets");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues randomAccessVectorValues, byte[] queryVector) throws IOException {
        if (randomAccessVectorValues instanceof ByteVectorValues) {
            return new BinaryRandomVectorScorer((ByteVectorValues)randomAccessVectorValues, queryVector);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Bytes");
    }

    static class BinaryRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        protected final ByteVectorValues vectorValues;
        protected final ByteVectorValues vectorValues1;
        protected final ByteVectorValues vectorValues2;

        public BinaryRandomVectorScorerSupplier(ByteVectorValues vectorValues) throws IOException {
            this.vectorValues = vectorValues;
            this.vectorValues1 = vectorValues.copy();
            this.vectorValues2 = vectorValues.copy();
        }

        public RandomVectorScorer scorer(int ord) throws IOException {
            byte[] queryVector = this.vectorValues1.vectorValue(ord);
            return new BinaryRandomVectorScorer(this.vectorValues2, queryVector);
        }

        public RandomVectorScorerSupplier copy() throws IOException {
            return new BinaryRandomVectorScorerSupplier(this.vectorValues.copy());
        }
    }

    static class BinaryRandomVectorScorer
    implements RandomVectorScorer {
        private final ByteVectorValues vectorValues;
        private final byte[] queryVector;

        BinaryRandomVectorScorer(ByteVectorValues vectorValues, byte[] query) {
            this.queryVector = query;
            this.vectorValues = vectorValues;
        }

        public float score(int node) throws IOException {
            return KNNVectorSimilarityFunction.HAMMING.compare(this.queryVector, this.vectorValues.vectorValue(node));
        }

        public int maxOrd() {
            return this.vectorValues.size();
        }

        public int ordToDoc(int ord) {
            return this.vectorValues.ordToDoc(ord);
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.vectorValues.getAcceptOrds(acceptDocs);
        }
    }
}

