/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN10010Codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.IOUtils;
import org.opensearch.index.fieldvisitor.FieldsVisitor;
import org.opensearch.knn.index.codec.derivedsource.DerivedFieldInfo;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReadersSupplier;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceStoredFieldVisitor;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceVectorTransformer;

public class KNN10010DerivedSourceStoredFieldsReader
extends StoredFieldsReader {
    private final StoredFieldsReader delegate;
    private final List<DerivedFieldInfo> derivedVectorFields;
    private final DerivedSourceReadersSupplier derivedSourceReadersSupplier;
    private final SegmentReadState segmentReadState;
    private final boolean shouldInject;
    private final DerivedSourceVectorTransformer derivedSourceVectorTransformer;

    public KNN10010DerivedSourceStoredFieldsReader(StoredFieldsReader delegate, List<DerivedFieldInfo> derivedVectorFields, DerivedSourceReadersSupplier derivedSourceReadersSupplier, SegmentReadState segmentReadState) throws IOException {
        this(delegate, derivedVectorFields, derivedSourceReadersSupplier, segmentReadState, true);
    }

    private KNN10010DerivedSourceStoredFieldsReader(StoredFieldsReader delegate, List<DerivedFieldInfo> derivedVectorFields, DerivedSourceReadersSupplier derivedSourceReadersSupplier, SegmentReadState segmentReadState, boolean shouldInject) throws IOException {
        this.delegate = delegate;
        this.derivedVectorFields = derivedVectorFields;
        this.derivedSourceReadersSupplier = derivedSourceReadersSupplier;
        this.segmentReadState = segmentReadState;
        this.shouldInject = shouldInject;
        this.derivedSourceVectorTransformer = this.createDerivedSourceVectorTransformer();
    }

    private DerivedSourceVectorTransformer createDerivedSourceVectorTransformer() throws IOException {
        return new DerivedSourceVectorTransformer(this.derivedSourceReadersSupplier, this.segmentReadState, this.derivedVectorFields);
    }

    public void document(int docId, StoredFieldVisitor storedFieldVisitor) throws IOException {
        if (this.shouldInject && this.doesVisitorNeedVectors(storedFieldVisitor)) {
            this.delegate.document(docId, (StoredFieldVisitor)new DerivedSourceStoredFieldVisitor(storedFieldVisitor, docId, this.derivedSourceVectorTransformer));
            return;
        }
        this.delegate.document(docId, storedFieldVisitor);
    }

    private boolean doesVisitorNeedVectors(StoredFieldVisitor delegate) {
        if (delegate instanceof FieldsVisitor) {
            return this.derivedSourceVectorTransformer.shouldInject(((FieldsVisitor)delegate).includes(), ((FieldsVisitor)delegate).excludes());
        }
        return true;
    }

    public StoredFieldsReader clone() {
        try {
            return new KNN10010DerivedSourceStoredFieldsReader(this.delegate.clone(), this.derivedVectorFields, this.derivedSourceReadersSupplier, this.segmentReadState, this.shouldInject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.delegate, this.derivedSourceVectorTransformer});
    }

    private StoredFieldsReader cloneForMerge() {
        try {
            return new KNN10010DerivedSourceStoredFieldsReader(this.delegate.getMergeInstance(), this.derivedVectorFields, this.derivedSourceReadersSupplier, this.segmentReadState, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static StoredFieldsReader wrapForMerge(StoredFieldsReader storedFieldsReader) {
        if (storedFieldsReader instanceof KNN10010DerivedSourceStoredFieldsReader) {
            return ((KNN10010DerivedSourceStoredFieldsReader)storedFieldsReader).cloneForMerge();
        }
        return storedFieldsReader;
    }
}

