/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN10010Codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.opensearch.common.Nullable;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.codec.KNN10010Codec.KNN10010DerivedSourceStoredFieldsReader;
import org.opensearch.knn.index.codec.KNN10010Codec.KNN10010DerivedSourceStoredFieldsWriter;
import org.opensearch.knn.index.codec.derivedsource.DerivedFieldInfo;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReadersSupplier;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceSegmentAttributeParser;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.util.IndexUtil;

public class KNN10010DerivedSourceStoredFieldsFormat
extends StoredFieldsFormat {
    private final StoredFieldsFormat delegate;
    private final DerivedSourceReadersSupplier derivedSourceReadersSupplier;
    @Nullable
    private final MapperService mapperService;

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext ioContext) throws IOException {
        List<DerivedFieldInfo> derivedVectorFields = Stream.concat(DerivedSourceSegmentAttributeParser.parseDerivedVectorFields(segmentInfo, false).stream().filter(field -> fieldInfos.fieldInfo(field) != null).map(field -> new DerivedFieldInfo(fieldInfos.fieldInfo(field), false)), DerivedSourceSegmentAttributeParser.parseDerivedVectorFields(segmentInfo, true).stream().filter(field -> fieldInfos.fieldInfo(field) != null).map(field -> new DerivedFieldInfo(fieldInfos.fieldInfo(field), true))).toList();
        if (derivedVectorFields.isEmpty()) {
            return this.delegate.fieldsReader(directory, segmentInfo, fieldInfos, ioContext);
        }
        return new KNN10010DerivedSourceStoredFieldsReader(this.delegate.fieldsReader(directory, segmentInfo, fieldInfos, ioContext), derivedVectorFields, this.derivedSourceReadersSupplier, new SegmentReadState(directory, segmentInfo, fieldInfos, ioContext));
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo segmentInfo, IOContext ioContext) throws IOException {
        StoredFieldsWriter delegateWriter = this.delegate.fieldsWriter(directory, segmentInfo, ioContext);
        if (!IndexUtil.isDerivedEnabledForIndex(this.mapperService)) {
            return delegateWriter;
        }
        ArrayList<String> vectorFieldTypes = new ArrayList<String>();
        ArrayList<String> nestedVectorFieldTypes = new ArrayList<String>();
        for (MappedFieldType fieldType : this.mapperService.fieldTypes()) {
            boolean isNested;
            KNNVectorFieldType knnVectorFieldType;
            if (!(fieldType instanceof KNNVectorFieldType) || !IndexUtil.isDerivedEnabledForField(knnVectorFieldType = (KNNVectorFieldType)fieldType, this.mapperService)) continue;
            boolean bl = isNested = this.mapperService.documentMapper().mappers().getNestedScope(fieldType.name()) != null;
            if (isNested) {
                nestedVectorFieldTypes.add(fieldType.name());
                continue;
            }
            vectorFieldTypes.add(fieldType.name());
        }
        if (vectorFieldTypes.isEmpty() && nestedVectorFieldTypes.isEmpty()) {
            return delegateWriter;
        }
        if (!vectorFieldTypes.isEmpty()) {
            DerivedSourceSegmentAttributeParser.addDerivedVectorFieldsSegmentInfoAttribute(segmentInfo, vectorFieldTypes, false);
        }
        if (!nestedVectorFieldTypes.isEmpty()) {
            vectorFieldTypes.addAll(nestedVectorFieldTypes);
            DerivedSourceSegmentAttributeParser.addDerivedVectorFieldsSegmentInfoAttribute(segmentInfo, nestedVectorFieldTypes, true);
        }
        return new KNN10010DerivedSourceStoredFieldsWriter(delegateWriter, vectorFieldTypes);
    }

    @Generated
    public KNN10010DerivedSourceStoredFieldsFormat(StoredFieldsFormat delegate, DerivedSourceReadersSupplier derivedSourceReadersSupplier, MapperService mapperService) {
        this.delegate = delegate;
        this.derivedSourceReadersSupplier = derivedSourceReadersSupplier;
        this.mapperService = mapperService;
    }
}

