/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.ExceptionsHelper;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.knn.index.VectorDataType;

public abstract class KNNVectorScriptDocValues
extends ScriptDocValues<float[]> {
    private final DocIdSetIterator vectorValues;
    private final String fieldName;
    private final VectorDataType vectorDataType;
    private boolean docExists = false;
    private int lastDocID = -1;

    public void setNextDocId(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + docId);
        }
        this.lastDocID = docId;
        int curDocID = this.vectorValues.docID();
        if (this.lastDocID > curDocID) {
            curDocID = this.vectorValues.advance(docId);
        }
        this.docExists = this.lastDocID == curDocID;
    }

    public float[] getValue() {
        if (!this.docExists) {
            String errorMessage = String.format("One of the document doesn't have a value for field '%s'. This can be avoided by checking if a document has a value for the field or not by doc['%s'].size() == 0 ? 0 : {your script}", this.fieldName, this.fieldName);
            throw new IllegalStateException(errorMessage);
        }
        try {
            return this.doGetValue();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    protected abstract float[] doGetValue() throws IOException;

    public int size() {
        return this.docExists ? 1 : 0;
    }

    public float[] get(int i) {
        throw new UnsupportedOperationException("knn vector does not support this operation");
    }

    public static KNNVectorScriptDocValues create(KnnVectorValues knnVectorValues, String fieldName, VectorDataType vectorDataType) {
        Objects.requireNonNull(knnVectorValues, "values must not be null");
        if (knnVectorValues instanceof FloatVectorValues) {
            return new KNNFloatVectorScriptDocValues((FloatVectorValues)knnVectorValues, fieldName, vectorDataType);
        }
        if (knnVectorValues instanceof ByteVectorValues) {
            return new KNNByteVectorScriptDocValues((ByteVectorValues)knnVectorValues, fieldName, vectorDataType);
        }
        throw new IllegalArgumentException("Unsupported values type: " + String.valueOf(knnVectorValues.getClass()));
    }

    public static KNNVectorScriptDocValues create(DocIdSetIterator docIdSetIterator, String fieldName, VectorDataType vectorDataType) {
        Objects.requireNonNull(docIdSetIterator, "values must not be null");
        if (docIdSetIterator instanceof BinaryDocValues) {
            return new KNNNativeVectorScriptDocValues((BinaryDocValues)docIdSetIterator, fieldName, vectorDataType);
        }
        throw new IllegalArgumentException("Unsupported values type: " + String.valueOf(docIdSetIterator.getClass()));
    }

    public static KNNVectorScriptDocValues emptyValues(String fieldName, VectorDataType type) {
        return new KNNVectorScriptDocValues(DocIdSetIterator.empty(), fieldName, type){

            @Override
            protected float[] doGetValue() throws IOException {
                throw new UnsupportedOperationException("empty values");
            }
        };
    }

    @Generated
    private KNNVectorScriptDocValues(DocIdSetIterator vectorValues, String fieldName, VectorDataType vectorDataType) {
        this.vectorValues = vectorValues;
        this.fieldName = fieldName;
        this.vectorDataType = vectorDataType;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    private static final class KNNFloatVectorScriptDocValues
    extends KNNVectorScriptDocValues {
        private final FloatVectorValues values;
        private final KnnVectorValues.DocIndexIterator iterator;

        KNNFloatVectorScriptDocValues(FloatVectorValues values, String field, VectorDataType type) {
            super((DocIdSetIterator)values.iterator(), field, type);
            this.values = values;
            this.iterator = this.vectorValues instanceof KnnVectorValues.DocIndexIterator ? (KnnVectorValues.DocIndexIterator)this.vectorValues : values.iterator();
        }

        @Override
        protected float[] doGetValue() throws IOException {
            int ord = this.iterator.index();
            if (ord == Integer.MAX_VALUE) {
                throw new IllegalStateException("No more ordinals to retrieve vector values.");
            }
            return this.values.vectorValue(ord);
        }
    }

    private static final class KNNByteVectorScriptDocValues
    extends KNNVectorScriptDocValues {
        private final ByteVectorValues values;
        private final KnnVectorValues.DocIndexIterator iterator;

        KNNByteVectorScriptDocValues(ByteVectorValues values, String field, VectorDataType type) {
            super((DocIdSetIterator)values.iterator(), field, type);
            this.values = values;
            this.iterator = this.vectorValues instanceof KnnVectorValues.DocIndexIterator ? (KnnVectorValues.DocIndexIterator)this.vectorValues : values.iterator();
        }

        @Override
        protected float[] doGetValue() throws IOException {
            int docId = this.iterator.index();
            if (docId == Integer.MAX_VALUE) {
                throw new IllegalStateException("No more ordinals to retrieve vector values.");
            }
            byte[] bytes = this.values.vectorValue(docId);
            float[] value = new float[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                value[i] = bytes[i];
            }
            return value;
        }
    }

    private static final class KNNNativeVectorScriptDocValues
    extends KNNVectorScriptDocValues {
        private final BinaryDocValues values;

        KNNNativeVectorScriptDocValues(BinaryDocValues values, String field, VectorDataType type) {
            super((DocIdSetIterator)values, field, type);
            this.values = values;
        }

        @Override
        protected float[] doGetValue() throws IOException {
            return this.getVectorDataType().getVectorFromBytesRef(this.values.binaryValue());
        }
    }
}

