/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.common.featureflags;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.opensearch.common.Booleans;
import org.opensearch.common.settings.Setting;
import org.opensearch.knn.index.KNNSettings;

public final class KNNFeatureFlags {
    private static final String KNN_FORCE_EVICT_CACHE_ENABLED = "knn.feature.cache.force_evict.enabled";
    private static final String KNN_REMOTE_VECTOR_BUILD = "knn.feature.remote_index_build.enabled";
    @VisibleForTesting
    public static final Setting<Boolean> KNN_FORCE_EVICT_CACHE_ENABLED_SETTING = Setting.boolSetting((String)"knn.feature.cache.force_evict.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> KNN_REMOTE_VECTOR_BUILD_SETTING = Setting.boolSetting((String)"knn.feature.remote_index_build.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public static List<Setting<?>> getFeatureFlags() {
        return ImmutableList.of(KNN_FORCE_EVICT_CACHE_ENABLED_SETTING, KNN_REMOTE_VECTOR_BUILD_SETTING);
    }

    public static boolean isForceEvictCacheEnabled() {
        return Booleans.parseBoolean((String)KNNSettings.state().getSettingValue(KNN_FORCE_EVICT_CACHE_ENABLED).toString(), (boolean)false);
    }

    public static boolean isKNNRemoteVectorBuildEnabled() {
        return Booleans.parseBooleanStrict((String)KNNSettings.state().getSettingValue(KNN_REMOTE_VECTOR_BUILD).toString(), (boolean)false);
    }

    @Generated
    private KNNFeatureFlags() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

