/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.flowframework.exception.ApiSpecParseException;
import org.opensearch.rest.RestRequest;

public class ApiSpecFetcher {
    private static final Logger logger = LogManager.getLogger(ApiSpecFetcher.class);
    private static final ParseOptions PARSE_OPTIONS = new ParseOptions();
    private static final OpenAPIV3Parser OPENAPI_PARSER = new OpenAPIV3Parser();

    private ApiSpecFetcher() {
    }

    public static OpenAPI fetchApiSpec(String apiSpecUri) {
        logger.info("Parsing API spec from URI: {}", (Object)apiSpecUri);
        SwaggerParseResult result = OPENAPI_PARSER.readLocation(apiSpecUri, null, PARSE_OPTIONS);
        OpenAPI openApi = result.getOpenAPI();
        if (openApi == null) {
            throw new ApiSpecParseException("Unable to parse spec from URI: " + apiSpecUri, result.getMessages());
        }
        return openApi;
    }

    public static boolean compareRequiredFields(List<String> requiredEnumParams, String apiSpecUri, String path, RestRequest.Method method) throws IllegalArgumentException, ApiSpecParseException {
        Schema schema;
        List requiredApiParams;
        OpenAPI openAPI = ApiSpecFetcher.fetchApiSpec(apiSpecUri);
        PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)path);
        Content content = ApiSpecFetcher.getContent(method, pathItem);
        MediaType mediaType = (MediaType)content.get((Object)XContentType.JSON.mediaTypeWithoutParameters());
        if (mediaType != null && (requiredApiParams = (schema = mediaType.getSchema()).getRequired()) != null && !requiredApiParams.isEmpty()) {
            return requiredApiParams.stream().allMatch(requiredEnumParams::contains);
        }
        return false;
    }

    private static Content getContent(RestRequest.Method method, PathItem pathItem) throws IllegalArgumentException, ApiSpecParseException {
        Operation operation = switch (method) {
            case RestRequest.Method.POST -> pathItem.getPost();
            case RestRequest.Method.GET -> pathItem.getGet();
            case RestRequest.Method.PUT -> pathItem.getPut();
            case RestRequest.Method.DELETE -> pathItem.getDelete();
            default -> throw new IllegalArgumentException("Unsupported HTTP method: " + String.valueOf(method));
        };
        if (operation == null) {
            throw new IllegalArgumentException("No operation found for the specified method: " + String.valueOf(method));
        }
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            throw new ApiSpecParseException("No requestBody defined for this operation.");
        }
        return requestBody.getContent();
    }

    static {
        PARSE_OPTIONS.setResolve(true);
        PARSE_OPTIONS.setResolveFully(true);
    }
}

