/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.GetAlertsRequest;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

@ToolAnnotation(value="SearchAlertsTool")
public class SearchAlertsTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchAlertsTool.class);
    public static final String TYPE = "SearchAlertsTool";
    private static final String DEFAULT_DESCRIPTION = "This is a tool that finds alerts. It takes 12 optional argument named sortOrder which defines the order of the results (options are asc or desc, and default is asc), and sortString which defines how to sort the results (default is monitor_name.keyword), and size which defines the size of the request to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0), and searchString which defines the search string to use for searching a specific alert (default is an empty String), and severityLevel which defines the severity level to filter for as an integer (default is ALL), and alertState which defines the alert state to filter for (options are ALL, ACTIVE, ERROR, COMPLETED, or ACKNOWLEDGED, default is ALL), and monitorId which defines the associated monitor ID to filter for, and alertIndex which defines the alert index to search from (default is null), and monitorIds which defines the list of monitor IDs to filter for, and workflowIds which defines the list of workflow IDs to filter for\uff08default is null), and alertIds which defines the list of alert IDs to filter for (default is null). The tool returns 2 values: a list of alerts (each containining the alert id, version, schema version, monitor ID, workflow ID, workflow name, monitor name, monitor version, monitor user, trigger ID, trigger name, finding IDs, related doc IDs, state, start time in epoch milliseconds, end time in epoch milliseconds, last notification time in epoch milliseconds, acknowledged time in epoch milliseconds, error message, error history, severity, action execution results, aggregation result bucket, execution ID, associated alert IDs), and the total number of alerts.";
    private String name = "SearchAlertsTool";
    private String description = "This is a tool that finds alerts. It takes 12 optional argument named sortOrder which defines the order of the results (options are asc or desc, and default is asc), and sortString which defines how to sort the results (default is monitor_name.keyword), and size which defines the size of the request to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0), and searchString which defines the search string to use for searching a specific alert (default is an empty String), and severityLevel which defines the severity level to filter for as an integer (default is ALL), and alertState which defines the alert state to filter for (options are ALL, ACTIVE, ERROR, COMPLETED, or ACKNOWLEDGED, default is ALL), and monitorId which defines the associated monitor ID to filter for, and alertIndex which defines the alert index to search from (default is null), and monitorIds which defines the list of monitor IDs to filter for, and workflowIds which defines the list of workflow IDs to filter for\uff08default is null), and alertIds which defines the list of alert IDs to filter for (default is null). The tool returns 2 values: a list of alerts (each containining the alert id, version, schema version, monitor ID, workflow ID, workflow name, monitor name, monitor version, monitor user, trigger ID, trigger name, finding IDs, related doc IDs, state, start time in epoch milliseconds, end time in epoch milliseconds, last notification time in epoch milliseconds, acknowledged time in epoch milliseconds, error message, error history, severity, action execution results, aggregation result bucket, execution ID, associated alert IDs), and the total number of alerts.";
    private String type;
    private String version;
    private Client client;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;
    private Map<String, Object> attributes;

    public SearchAlertsTool(Client client) {
        this.client = client;
        this.outputParser = new Parser<Object, Object>(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        String tableSortOrder = parameters.getOrDefault("sortOrder", "asc");
        String tableSortString = parameters.getOrDefault("sortString", "monitor_name.keyword");
        int tableSize = parameters.containsKey("size") && StringUtils.isNumeric((CharSequence)parameters.get("size")) ? Integer.parseInt(parameters.get("size")) : 20;
        int startIndex = parameters.containsKey("startIndex") && StringUtils.isNumeric((CharSequence)parameters.get("startIndex")) ? Integer.parseInt(parameters.get("startIndex")) : 0;
        String searchString = parameters.getOrDefault("searchString", null);
        Table table = new Table(tableSortOrder, tableSortString, null, tableSize, startIndex, searchString);
        String severityLevel = parameters.getOrDefault("severityLevel", "ALL");
        String alertState = parameters.getOrDefault("alertState", "ALL");
        String monitorId = parameters.getOrDefault("monitorId", null);
        String alertIndex = parameters.getOrDefault("alertIndex", null);
        List monitorIds = parameters.containsKey("monitorIds") ? (List)org.opensearch.ml.common.utils.StringUtils.gson.fromJson(parameters.get("monitorIds"), List.class) : null;
        List workflowIds = parameters.containsKey("workflowIds") ? (List)org.opensearch.ml.common.utils.StringUtils.gson.fromJson(parameters.get("workflowIds"), List.class) : null;
        List alertIds = parameters.containsKey("alertIds") ? (List)org.opensearch.ml.common.utils.StringUtils.gson.fromJson(parameters.get("alertIds"), List.class) : null;
        GetAlertsRequest getAlertsRequest = new GetAlertsRequest(table, severityLevel, alertState, monitorId, alertIndex, monitorIds, workflowIds, alertIds, null);
        ActionListener getAlertsListener = ActionListener.wrap(response -> {
            StringBuilder sb = new StringBuilder();
            sb.append("Alerts=[");
            for (Alert alert : response.getAlerts()) {
                sb.append(alert.toString());
            }
            sb.append("]");
            sb.append("TotalAlerts=").append(response.getTotalAlerts());
            listener.onResponse((Object)sb.toString());
        }, e -> {
            log.error("Failed to search alerts.", (Throwable)e);
            listener.onFailure(e);
        });
        AlertingPluginInterface.INSTANCE.getAlerts((NodeClient)this.client, getAlertsRequest, getAlertsListener);
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static class Factory
    implements Tool.Factory<SearchAlertsTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchAlertsTool> clazz = SearchAlertsTool.class;
            synchronized (SearchAlertsTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public SearchAlertsTool create(Map<String, Object> map) {
            return new SearchAlertsTool(this.client);
        }

        public String getDefaultDescription() {
            return SearchAlertsTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchAlertsTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

