/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.resthandler.top_queries;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesAction;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesRequest;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesResponse;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestTopQueriesAction
extends BaseRestHandler {
    static final Set<String> ALLOWED_METRICS = MetricType.allMetricTypes().stream().map(MetricType::toString).collect(Collectors.toSet());

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_insights/top_queries"), new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{nodeId}", "/_insights/top_queries")));
    }

    public String getName() {
        return "query_insights_top_queries_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        TopQueriesRequest topQueriesRequest = RestTopQueriesAction.prepareRequest(request);
        topQueriesRequest.timeout(request.param("timeout"));
        return channel -> client.execute((ActionType)TopQueriesAction.INSTANCE, (ActionRequest)topQueriesRequest, this.topQueriesResponse((RestChannel)channel));
    }

    private static boolean isNotISODate(String dateTime) {
        try {
            ZonedDateTime.parse(dateTime);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    static TopQueriesRequest prepareRequest(RestRequest request) {
        boolean isTimeRangeProvided;
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        String metricType = request.param("type", MetricType.LATENCY.toString());
        String from = request.param("from", null);
        String to = request.param("to", null);
        String id = request.param("id", null);
        if (!ALLOWED_METRICS.contains(metricType)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains invalid metric type [%s]", request.path(), metricType));
        }
        boolean bl = isTimeRangeProvided = from != null || to != null;
        if (isTimeRangeProvided) {
            RestTopQueriesAction.validateTimeRange(request, from, to);
        }
        return new TopQueriesRequest(MetricType.fromString(metricType), from, to, id, nodesIds);
    }

    private static void validateTimeRange(RestRequest request, String from, String to) {
        if (from != null ^ to != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] is missing one of the time parameters. Both must be provided", request.path()));
        }
        if (RestTopQueriesAction.isNotISODate(from)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains invalid 'from' date format. Expected ISO8601 format string (YYYY-MM-DD'T'HH:mm:ss.SSSZ): [%s]", request.path(), from));
        }
        if (RestTopQueriesAction.isNotISODate(to)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains invalid 'to' date format. Expected ISO8601 format string (YYYY-MM-DD'T'HH:mm:ss.SSSZ): [%s]", request.path(), to));
        }
    }

    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }

    private RestResponseListener<TopQueriesResponse> topQueriesResponse(RestChannel channel) {
        return new RestResponseListener<TopQueriesResponse>(this, channel){

            public RestResponse buildResponse(TopQueriesResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

