/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.reader;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.plugin.insights.core.reader.QueryInsightsReader;
import org.opensearch.plugin.insights.core.utils.ExporterReaderUtils;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.client.Client;

public final class LocalIndexReader
implements QueryInsightsReader {
    private static final int MAX_TOP_N_INDEX_READ_SIZE = 50;
    private final Logger logger = LogManager.getLogger();
    private final Client client;
    private DateTimeFormatter indexPattern;
    private final NamedXContentRegistry namedXContentRegistry;
    private final String id;

    public LocalIndexReader(Client client, DateTimeFormatter indexPattern, NamedXContentRegistry namedXContentRegistry, String id) {
        this.indexPattern = indexPattern;
        this.client = client;
        this.id = id;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public DateTimeFormatter getIndexPattern() {
        return this.indexPattern;
    }

    public LocalIndexReader setIndexPattern(DateTimeFormatter indexPattern) {
        this.indexPattern = indexPattern;
        return this;
    }

    @Override
    public List<SearchQueryRecord> read(String from, String to, String id) {
        ZonedDateTime now;
        ArrayList<SearchQueryRecord> records = new ArrayList<SearchQueryRecord>();
        if (from == null || to == null) {
            return records;
        }
        ZonedDateTime start = ZonedDateTime.parse(from);
        ZonedDateTime end = ZonedDateTime.parse(to);
        if (end.isAfter(now = ZonedDateTime.now(ZoneOffset.UTC))) {
            end = now;
        }
        ZonedDateTime curr = start;
        while (curr.isBefore(end.plusDays(1L).toLocalDate().atStartOfDay(end.getZone()))) {
            String indexName = this.buildLocalIndexName(curr);
            SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(50);
            MatchQueryBuilder excludeQuery = QueryBuilders.matchQuery((String)"indices", (Object)"top_queries*");
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"timestamp").from((Object)start.toInstant().toEpochMilli()).to((Object)end.toInstant().toEpochMilli());
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery).mustNot((QueryBuilder)excludeQuery);
            if (id != null) {
                query.must((QueryBuilder)QueryBuilders.matchQuery((String)"id", (Object)id));
            }
            searchSourceBuilder.query((QueryBuilder)query);
            searchSourceBuilder.sort(SortBuilders.fieldSort((String)"measurements.latency.number").order(SortOrder.DESC));
            searchRequest.source(searchSourceBuilder);
            try {
                SearchResponse searchResponse = (SearchResponse)this.client.search(searchRequest).actionGet();
                for (SearchHit hit : searchResponse.getHits()) {
                    XContentParser parser = XContentType.JSON.xContent().createParser(this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    SearchQueryRecord record = SearchQueryRecord.fromXContent(parser);
                    records.add(record);
                }
            }
            catch (IndexNotFoundException searchResponse) {
            }
            catch (Exception e) {
                OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.LOCAL_INDEX_READER_PARSING_EXCEPTIONS);
                this.logger.error("Unable to parse search hit: ", (Throwable)e);
            }
            curr = curr.plusDays(1L);
        }
        return records;
    }

    @Override
    public void close() {
        this.logger.debug("Closing the LocalIndexReader..");
    }

    private String buildLocalIndexName(ZonedDateTime current) {
        return current.format(this.indexPattern) + "-" + ExporterReaderUtils.generateLocalIndexDateHash(current.toLocalDate());
    }
}

