/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly.example;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.tribuo.DataSource;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.anomaly.AnomalyFactory;
import org.tribuo.anomaly.Event;
import org.tribuo.datasource.ListDataSource;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DataSourceProvenance;
import org.tribuo.provenance.SimpleDataSourceProvenance;

public abstract class AnomalyDataGenerator {
    private static AnomalyFactory anomalyFactory = new AnomalyFactory();

    public static Pair<Dataset<Event>, Dataset<Event>> gaussianAnomaly() {
        return AnomalyDataGenerator.gaussianAnomaly(200L, 0.2);
    }

    public static Pair<Dataset<Event>, Dataset<Event>> gaussianAnomaly(long size, double fractionAnomalous) {
        if (size < 1L) {
            throw new IllegalArgumentException("Size must be a positive number, received " + size);
        }
        if (fractionAnomalous > 1.0 || fractionAnomalous < 0.0) {
            throw new IllegalArgumentException("FractionAnomalous must be between zero and one, received " + fractionAnomalous);
        }
        Random rng = new Random(1L);
        String[] featureNames = new String[]{"A", "B", "C", "D", "E"};
        double[] expectedMeans = new double[]{1.0, 2.0, 1.0, 2.0, 5.0};
        double[] anomalousMeans = new double[]{-2.0, 2.0, -2.0, 2.0, -10.0};
        double[] variances = new double[]{1.0, 0.5, 0.25, 1.0, 0.1};
        ArrayList<ArrayExample> trainingData = new ArrayList<ArrayExample>();
        int i = 0;
        while ((long)i < size) {
            List<Feature> featureList = AnomalyDataGenerator.generateFeatures(rng, featureNames, expectedMeans, variances);
            trainingData.add(new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, featureList));
            ++i;
        }
        ArrayList<ArrayExample> testingData = new ArrayList<ArrayExample>();
        int i2 = 0;
        while ((long)i2 < size) {
            List<Feature> featureList;
            double draw = rng.nextDouble();
            if (draw < fractionAnomalous) {
                featureList = AnomalyDataGenerator.generateFeatures(rng, featureNames, anomalousMeans, variances);
                testingData.add(new ArrayExample((Output)AnomalyFactory.ANOMALOUS_EVENT, featureList));
            } else {
                featureList = AnomalyDataGenerator.generateFeatures(rng, featureNames, expectedMeans, variances);
                testingData.add(new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, featureList));
            }
            ++i2;
        }
        SimpleDataSourceProvenance trainingProvenance = new SimpleDataSourceProvenance("Anomaly training data", (OutputFactory)anomalyFactory);
        MutableDataset train = new MutableDataset((DataSource)new ListDataSource(trainingData, (OutputFactory)anomalyFactory, (DataSourceProvenance)trainingProvenance));
        SimpleDataSourceProvenance testingProvenance = new SimpleDataSourceProvenance("Anomaly testing data", (OutputFactory)anomalyFactory);
        MutableDataset test = new MutableDataset((DataSource)new ListDataSource(testingData, (OutputFactory)anomalyFactory, (DataSourceProvenance)testingProvenance));
        return new Pair((Object)train, (Object)test);
    }

    private static List<Feature> generateFeatures(Random rng, String[] names, double[] means, double[] variances) {
        if (names.length != means.length || names.length != variances.length) {
            throw new IllegalArgumentException("Names, means and variances must be the same length");
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < names.length; ++i) {
            double value = rng.nextGaussian() * Math.sqrt(variances[i]) + means[i];
            features.add(new Feature(names[i], value));
        }
        return features;
    }

    public static Pair<Dataset<Event>, Dataset<Event>> denseTrainTest() {
        return AnomalyDataGenerator.denseTrainTest(-1.0);
    }

    public static Pair<Dataset<Event>, Dataset<Event>> denseTrainTest(double negate) {
        MutableDataset train = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)anomalyFactory), (OutputFactory)anomalyFactory);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        MutableDataset test = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)anomalyFactory), (OutputFactory)anomalyFactory);
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Pair<Dataset<Event>, Dataset<Event>> sparseTrainTest() {
        return AnomalyDataGenerator.sparseTrainTest(-1.0);
    }

    public static Pair<Dataset<Event>, Dataset<Event>> sparseTrainTest(double negate) {
        MutableDataset train = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TrainingData", OffsetDateTime.now(), (OutputFactory)anomalyFactory), (OutputFactory)anomalyFactory);
        String[] names = new String[]{"A", "B", "C", "D"};
        double[] values = new double[]{1.0, 0.5, 1.0, negate * 1.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"B", "D", "F", "H"};
        values = new double[]{1.5, 0.35, 1.3, negate * 1.2};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"A", "J", "D", "M"};
        values = new double[]{1.2, 0.45, 1.5, negate * 1.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"C", "E", "F", "H"};
        values = new double[]{negate * 1.1, 0.55, negate * 1.5, 0.5};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"E", "G", "F", "I"};
        values = new double[]{negate * 1.5, 0.25, negate * 1.0, 0.125};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"J", "K", "C", "E"};
        values = new double[]{negate * 1.0, 0.5, negate * 1.123, 0.123};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"E", "A", "K", "J"};
        values = new double[]{1.5, 5.0, 0.5, 4.5};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"B", "C", "E", "H"};
        values = new double[]{1.234, 5.1235, 0.1235, 6.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"A", "M", "I", "J"};
        values = new double[]{1.734, 4.5, 0.5123, 5.5};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"Z", "A", "B", "C"};
        values = new double[]{negate * 1.0, 0.25, 5.0, 10.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"K", "V", "E", "D"};
        values = new double[]{negate * 1.4, 0.55, 5.65, 12.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"B", "G", "E", "A"};
        values = new double[]{negate * 1.9, 0.25, 5.9, 15.0};
        train.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        MutableDataset test = new MutableDataset((DataProvenance)new SimpleDataSourceProvenance("TestingData", OffsetDateTime.now(), (OutputFactory)anomalyFactory), (OutputFactory)anomalyFactory);
        names = new String[]{"AA", "B", "C", "D"};
        values = new double[]{2.0, 0.45, 3.5, negate * 2.0};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"B", "BB", "F", "E"};
        values = new double[]{negate * 2.0, 0.55, negate * 2.5, 2.5};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"B", "E", "G", "H"};
        values = new double[]{1.75, 5.0, 1.0, 6.5};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        names = new String[]{"B", "CC", "DD", "EE"};
        values = new double[]{negate * 1.5, 0.25, 5.0, 20.0};
        test.add((Example)new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, names, values));
        return new Pair((Object)train, (Object)test);
    }

    public static Example<Event> invalidSparseExample() {
        return new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, new String[]{"1", "5", "8"}, new double[]{1.0, 5.0, 8.0});
    }

    public static Example<Event> emptyExample() {
        return new ArrayExample((Output)AnomalyFactory.EXPECTED_EVENT, new String[0], new double[0]);
    }
}

