/*
 * Decompiled with CFR 0.152.
 */
package com.intel.qat;

import com.intel.qat.QatZipper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class QatDecompressorInputStream
extends FilterInputStream {
    private byte[] inputBuffer;
    private byte[] outputBuffer;
    private int inputPosition;
    private int outputPosition;
    private int inputBufferLimit;
    private int outputBufferLimit;
    private QatZipper qzip;
    private boolean closed;
    private boolean eof;
    public static final int DEFAULT_BUFFER_SIZE = 65536;

    public QatDecompressorInputStream(InputStream in, int bufferSize, QatZipper.Algorithm algorithm, QatZipper.Mode mode, QatZipper.PollingMode pmode) {
        super(in);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(in);
        this.inputBuffer = new byte[bufferSize];
        this.outputBuffer = new byte[bufferSize];
        this.outputPosition = this.outputBuffer.length;
        this.inputBufferLimit = bufferSize;
        this.outputBufferLimit = bufferSize;
        this.qzip = new QatZipper(algorithm, mode, pmode);
        this.closed = false;
        this.eof = false;
    }

    public QatDecompressorInputStream(InputStream in) {
        this(in, 65536, QatZipper.Algorithm.DEFLATE, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatDecompressorInputStream(InputStream in, int bufferSize) {
        this(in, bufferSize, QatZipper.Algorithm.DEFLATE, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatDecompressorInputStream(InputStream in, int bufferSize, QatZipper.Algorithm algorithm) {
        this(in, bufferSize, algorithm, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatDecompressorInputStream(InputStream in, int bufferSize, QatZipper.Mode mode) {
        this(in, bufferSize, QatZipper.Algorithm.DEFLATE, mode, QatZipper.PollingMode.BUSY);
    }

    public QatDecompressorInputStream(InputStream in, int bufferSize, QatZipper.PollingMode pmode) {
        this(in, bufferSize, QatZipper.Algorithm.DEFLATE, QatZipper.DEFAULT_MODE, pmode);
    }

    public QatDecompressorInputStream(InputStream in, int bufferSize, QatZipper.Algorithm algorithm, QatZipper.Mode mode) {
        this(in, bufferSize, algorithm, mode, QatZipper.PollingMode.BUSY);
    }

    public QatDecompressorInputStream(InputStream in, int bufferSize, QatZipper.Algorithm algorithm, QatZipper.PollingMode pmode) {
        this(in, bufferSize, algorithm, QatZipper.DEFAULT_MODE, pmode);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.eof && this.outputPosition == this.outputBufferLimit) {
            return -1;
        }
        if (this.outputPosition == this.outputBufferLimit) {
            this.fill();
        }
        if (this.eof && this.outputPosition == this.outputBufferLimit) {
            return -1;
        }
        return Byte.toUnsignedInt(this.outputBuffer[this.outputPosition++]);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eof && this.outputPosition == this.outputBufferLimit) {
            return -1;
        }
        int result = 0;
        int bytesToRead = 0;
        while (len > (bytesToRead = this.outputBufferLimit - this.outputPosition)) {
            System.arraycopy(this.outputBuffer, this.outputPosition, b, off, bytesToRead);
            this.outputPosition += bytesToRead;
            len -= bytesToRead;
            result += bytesToRead;
            off += bytesToRead;
            if (this.eof) {
                return result == 0 ? -1 : result;
            }
            this.fill();
        }
        System.arraycopy(this.outputBuffer, this.outputPosition, b, off, len);
        this.outputPosition += len;
        return result += len;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.outputPosition != this.outputBufferLimit) {
            return this.outputBufferLimit - this.outputPosition;
        }
        if (this.eof) {
            return 0;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.qzip.end();
        this.in.close();
        this.inputBuffer = null;
        this.outputBuffer = null;
        this.closed = true;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        return this.read(new byte[(int)n]);
    }

    private void fill() throws IOException {
        if (this.eof) {
            return;
        }
        int bytesRead = this.in.read(this.inputBuffer, this.inputPosition, this.inputBuffer.length - this.inputPosition);
        this.inputBufferLimit = this.inputPosition + Math.max(0, bytesRead);
        this.inputPosition = 0;
        if (bytesRead < 0 && this.inputBufferLimit == 0) {
            this.eof = true;
            return;
        }
        this.outputPosition = 0;
        this.outputBufferLimit = this.outputBuffer.length;
        int decompressed = this.qzip.decompress(this.inputBuffer, this.inputPosition, this.inputBufferLimit, this.outputBuffer, this.outputPosition, this.outputBufferLimit - this.outputPosition);
        this.inputPosition += this.qzip.getBytesRead();
        this.outputPosition += decompressed;
        this.outputBufferLimit = this.outputPosition;
        this.outputPosition = 0;
        if (this.inputPosition != this.inputBufferLimit) {
            System.arraycopy(this.inputBuffer, this.inputPosition, this.inputBuffer, 0, this.inputBufferLimit - this.inputPosition);
            this.inputPosition = this.inputBufferLimit - this.inputPosition;
            this.inputBufferLimit = this.inputBuffer.length;
        } else if (bytesRead < 0 && this.inputPosition == this.inputBufferLimit) {
            this.eof = true;
        } else {
            this.inputPosition = 0;
            this.inputBufferLimit = this.inputBuffer.length;
        }
        if (decompressed == 0) {
            this.fill();
        }
    }
}

