/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.forecast.constant.ForecastCommonMessages;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.rest.handler.IndexForecasterActionHandler;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.forecast.transport.IndexForecasterAction;
import org.opensearch.forecast.transport.IndexForecasterRequest;
import org.opensearch.forecast.transport.IndexForecasterResponse;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class IndexForecasterTransportAction
extends HandledTransportAction<IndexForecasterRequest, IndexForecasterResponse> {
    private static final Logger LOG = LogManager.getLogger(IndexForecasterTransportAction.class);
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final TransportService transportService;
    private final ForecastIndexManagement forecastIndices;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final SearchFeatureDao searchFeatureDao;
    private final ForecastTaskManager taskManager;
    private final Settings settings;

    @Inject
    public IndexForecasterTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SecurityClientUtil clientUtil, ClusterService clusterService, Settings settings, ForecastIndexManagement forecastIndices, NamedXContentRegistry xContentRegistry, SearchFeatureDao searchFeatureDao, ForecastTaskManager taskManager) {
        super(IndexForecasterAction.NAME, transportService, actionFilters, IndexForecasterRequest::new);
        this.client = client;
        this.clientUtil = clientUtil;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.forecastIndices = forecastIndices;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)ForecastSettings.FORECAST_FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.searchFeatureDao = searchFeatureDao;
        this.taskManager = taskManager;
        this.settings = settings;
    }

    protected void doExecute(Task task, IndexForecasterRequest request, ActionListener<IndexForecasterResponse> actionListener) {
        User user = ParseUtils.getUserContext(this.client);
        String forecasterId = request.getForecasterID();
        RestRequest.Method method = request.getMethod();
        String errorMessage = method == RestRequest.Method.PUT ? ForecastCommonMessages.FAIL_TO_UPDATE_FORECASTER : ForecastCommonMessages.FAIL_TO_CREATE_FORECASTER;
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, errorMessage);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.resolveUserAndExecute(user, forecasterId, method, (ActionListener<IndexForecasterResponse>)listener, forecaster -> this.forecastExecute(request, user, (Forecaster)forecaster, context, (ActionListener<IndexForecasterResponse>)listener));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void resolveUserAndExecute(User requestedUser, String forecasterId, RestRequest.Method method, ActionListener<IndexForecasterResponse> listener, Consumer<Forecaster> function) {
        try {
            String error;
            boolean filterByBackendRole;
            boolean bl = filterByBackendRole = requestedUser == null ? false : this.filterByEnabled;
            if (this.filterByEnabled.booleanValue() && (error = ParseUtils.checkFilterByBackendRoles(requestedUser)) != null) {
                listener.onFailure((Exception)new IllegalArgumentException(error));
                return;
            }
            if (method == RestRequest.Method.PUT) {
                ParseUtils.getConfig(requestedUser, forecasterId, listener, function, this.client, this.clusterService, this.xContentRegistry, filterByBackendRole, Forecaster.class);
            } else {
                function.accept(null);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void forecastExecute(IndexForecasterRequest request, User user, Forecaster currentForecaster, ThreadContext.StoredContext storedContext, ActionListener<IndexForecasterResponse> listener) {
        this.forecastIndices.update();
        String forecasterId = request.getForecasterID();
        long seqNo = request.getSeqNo();
        long primaryTerm = request.getPrimaryTerm();
        WriteRequest.RefreshPolicy refreshPolicy = request.getRefreshPolicy();
        Forecaster forecaster = request.getForecaster();
        RestRequest.Method method = request.getMethod();
        TimeValue requestTimeout = request.getRequestTimeout();
        Integer maxSingleStreamForecasters = request.getMaxSingleStreamForecasters();
        Integer maxHCForecasters = request.getMaxHCForecasters();
        Integer maxForecastFeatures = request.getMaxForecastFeatures();
        Integer maxCategoricalFields = request.getMaxCategoricalFields();
        storedContext.restore();
        this.checkIndicesAndExecute(forecaster.getIndices(), () -> {
            User forecastUser = currentForecaster == null ? user : currentForecaster.getUser();
            IndexForecasterActionHandler indexForecasterActionHandler = new IndexForecasterActionHandler(this.clusterService, this.client, this.clientUtil, this.transportService, this.forecastIndices, forecasterId, seqNo, primaryTerm, refreshPolicy, forecaster, requestTimeout, maxSingleStreamForecasters, maxHCForecasters, maxForecastFeatures, maxCategoricalFields, method, this.xContentRegistry, forecastUser, this.taskManager, this.searchFeatureDao, this.settings);
            indexForecasterActionHandler.start(listener);
        }, listener);
    }

    private void checkIndicesAndExecute(List<String> indices, ExecutorFunction function, ActionListener<IndexForecasterResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(indices.toArray(new String[0])).source(new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        this.client.search(searchRequest, ActionListener.wrap(r -> function.execute(), e -> {
            LOG.error(e);
            listener.onFailure(e);
        }));
    }
}

