/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.tools.democonfig;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.dlic.rest.validation.PasswordValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.hasher.PasswordHasherFactory;
import org.opensearch.security.tools.democonfig.Certificates;
import org.opensearch.security.tools.democonfig.ExecutionEnvironment;
import org.opensearch.security.tools.democonfig.Installer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class SecuritySettingsConfigurer {
    static final List<String> REST_ENABLED_ROLES = List.of("all_access", "security_rest_api_access");
    static final List<String> SYSTEM_INDICES = List.of(".plugins-ml-agent", ".plugins-ml-config", ".plugins-ml-connector", ".plugins-ml-controller", ".plugins-ml-model-group", ".plugins-ml-model", ".plugins-ml-task", ".plugins-ml-conversation-meta", ".plugins-ml-conversation-interactions", ".plugins-ml-memory-meta", ".plugins-ml-memory-message", ".plugins-ml-stop-words", ".opendistro-alerting-config", ".opendistro-alerting-alert*", ".opendistro-anomaly-results*", ".opendistro-anomaly-detector*", ".opendistro-anomaly-checkpoints", ".opendistro-anomaly-detection-state", ".opendistro-reports-*", ".opensearch-notifications-*", ".opensearch-notebooks", ".opensearch-observability", ".ql-datasources", ".opendistro-asynchronous-search-response*", ".replication-metadata-store", ".opensearch-knn-models", ".geospatial-ip2geo-data*", ".plugins-flow-framework-config", ".plugins-flow-framework-templates", ".plugins-flow-framework-state");
    static final Integer DEFAULT_PASSWORD_MIN_LENGTH = 8;
    static String ADMIN_PASSWORD = "";
    static String ADMIN_USERNAME = "admin";
    private final Installer installer;
    private final PasswordHasher passwordHasher;
    static final String DEFAULT_ADMIN_PASSWORD = "admin";

    public SecuritySettingsConfigurer(Installer installer) {
        this.installer = installer;
        this.passwordHasher = PasswordHasherFactory.createPasswordHasher(Settings.builder().put("plugins.security.password.hashing.algorithm", "bcrypt").build());
    }

    public void configureSecuritySettings() throws IOException {
        this.checkIfSecurityPluginIsAlreadyConfigured();
        this.updateAdminPassword();
        this.writeSecurityConfigToOpenSearchYML();
    }

    void checkIfSecurityPluginIsAlreadyConfigured() {
        block12: {
            if (this.installer.OPENSEARCH_CONF_FILE != null && new File(this.installer.OPENSEARCH_CONF_FILE).exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(this.installer.OPENSEARCH_CONF_FILE, StandardCharsets.UTF_8));){
                    Yaml yaml = new Yaml();
                    Map yamlData = (Map)yaml.load((Reader)br);
                    if (yamlData == null) break block12;
                    for (String key : yamlData.keySet()) {
                        if (!key.startsWith("plugins.security")) continue;
                        System.out.println(this.installer.OPENSEARCH_CONF_FILE + " seems to be already configured for Security. Quit.");
                        this.installer.getExitHandler().exit(this.installer.skip_updates);
                    }
                    if (yamlData.containsKey("plugins")) {
                        Map plugins = (Map)yamlData.get("plugins");
                        for (String key : plugins.keySet()) {
                            if (!key.startsWith("security")) continue;
                            System.out.println(this.installer.OPENSEARCH_CONF_FILE + " seems to be already configured for Security. Quit.");
                            this.installer.getExitHandler().exit(this.installer.skip_updates);
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Error reading configuration file.");
                    this.installer.getExitHandler().exit(-1);
                }
            } else {
                System.err.println("OpenSearch configuration file does not exist. Quit.");
                this.installer.getExitHandler().exit(-1);
            }
        }
    }

    void updateAdminPassword() throws IOException {
        String INTERNAL_USERS_FILE_PATH = this.installer.OPENSEARCH_CONF_DIR + "opensearch-security" + File.separator + "internal_users.yml";
        boolean shouldValidatePassword = this.installer.environment.equals((Object)ExecutionEnvironment.DEMO);
        if (!this.isAdminPasswordSetToAdmin(INTERNAL_USERS_FILE_PATH)) {
            System.out.println("Admin password seems to be custom configured. Skipping update to admin password.");
            return;
        }
        try {
            RequestContentValidator.ValidationError response;
            PasswordValidator passwordValidator = PasswordValidator.of(Settings.builder().put("plugins.security.restapi.password_validation_regex", "(?=.*[A-Z])(?=.*[^a-zA-Z\\\\d])(?=.*[0-9])(?=.*[a-z]).{8,}").put("plugins.security.restapi.password_min_length", DEFAULT_PASSWORD_MIN_LENGTH.intValue()).build());
            String initialAdminPassword = System.getenv().get("OPENSEARCH_INITIAL_ADMIN_PASSWORD");
            if (!Strings.isNullOrEmpty((String)initialAdminPassword)) {
                ADMIN_PASSWORD = initialAdminPassword;
            }
            if (shouldValidatePassword && !ADMIN_PASSWORD.isEmpty() && !RequestContentValidator.ValidationError.NONE.equals((Object)(response = passwordValidator.validate(ADMIN_USERNAME, ADMIN_PASSWORD)))) {
                System.out.println(String.format("Password %s failed validation: \"%s\". Please re-try with a minimum %d character password and must contain at least one uppercase letter, one lowercase letter, one digit, and one special character that is strong. Password strength can be tested here: https://lowe.github.io/tryzxcvbn", ADMIN_PASSWORD, response.message(), DEFAULT_PASSWORD_MIN_LENGTH));
                this.installer.getExitHandler().exit(-1);
            }
            if (Strings.isNullOrEmpty((String)ADMIN_PASSWORD)) {
                System.out.println(String.format("No custom admin password found. Please provide a password via the environment variable %s.", "OPENSEARCH_INITIAL_ADMIN_PASSWORD"));
                this.installer.getExitHandler().exit(-1);
            }
            this.writePasswordToInternalUsersFile(ADMIN_PASSWORD, INTERNAL_USERS_FILE_PATH);
            System.out.println("Admin password set successfully.");
        }
        catch (IOException e) {
            System.out.println("Exception updating the admin password : " + e.getMessage());
            this.installer.getExitHandler().exit(-1);
        }
    }

    private boolean isAdminPasswordSetToAdmin(String internalUsersFile) throws IOException {
        JsonNode internalUsers = DefaultObjectMapper.YAML_MAPPER.readTree((InputStream)new FileInputStream(internalUsersFile));
        return internalUsers.has(DEFAULT_ADMIN_PASSWORD) && this.passwordHasher.check(DEFAULT_ADMIN_PASSWORD.toCharArray(), internalUsers.get(DEFAULT_ADMIN_PASSWORD).get("hash").asText());
    }

    void writePasswordToInternalUsersFile(String adminPassword, String internalUsersFile) throws IOException {
        String hashedAdminPassword = this.passwordHasher.hash(adminPassword.toCharArray());
        if (hashedAdminPassword.isEmpty()) {
            System.out.println("Failure while hashing the admin password, see console for details.");
            this.installer.getExitHandler().exit(-1);
        }
        try {
            Map map = (Map)DefaultObjectMapper.YAML_MAPPER.readValue(new File(internalUsersFile), (TypeReference)new TypeReference<Map<String, LinkedHashMap<String, Object>>>(this){});
            LinkedHashMap admin = (LinkedHashMap)map.get(DEFAULT_ADMIN_PASSWORD);
            if (admin != null) {
                admin.put("hash", hashedAdminPassword);
            }
            DefaultObjectMapper.YAML_MAPPER.writeValue(new File(internalUsersFile), (Object)map);
        }
        catch (IOException e) {
            throw new IOException("Unable to update the internal users file with the hashed password.");
        }
    }

    void writeSecurityConfigToOpenSearchYML() {
        String configHeader = System.lineSeparator() + System.lineSeparator() + "######## Start OpenSearch Security Demo Configuration ########" + System.lineSeparator() + "# WARNING: revise all the lines below before you go into production" + System.lineSeparator();
        String configFooter = "######## End OpenSearch Security Demo Configuration ########" + System.lineSeparator();
        Map<String, Object> securityConfigAsMap = this.buildSecurityConfigMap();
        try (FileWriter writer = new FileWriter(this.installer.OPENSEARCH_CONF_FILE, StandardCharsets.UTF_8, true);){
            writer.write(configHeader);
            Yaml yaml = new Yaml();
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            String yamlString = yaml.dump(securityConfigAsMap);
            writer.write(yamlString);
            writer.write(configFooter);
        }
        catch (IOException e) {
            System.err.println("Exception writing security configuration to opensearch.yml : " + e.getMessage());
            this.installer.getExitHandler().exit(-1);
        }
    }

    Map<String, Object> buildSecurityConfigMap() {
        LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
        configMap.put("plugins.security.ssl.transport.pemcert_filepath", Certificates.NODE_CERT.getFileName());
        configMap.put("plugins.security.ssl.transport.pemkey_filepath", Certificates.NODE_KEY.getFileName());
        configMap.put("plugins.security.ssl.transport.pemtrustedcas_filepath", Certificates.ROOT_CA.getFileName());
        configMap.put("plugins.security.ssl.transport.enforce_hostname_verification", false);
        configMap.put("plugins.security.ssl.http.enabled", true);
        configMap.put("plugins.security.ssl.http.pemcert_filepath", Certificates.NODE_CERT.getFileName());
        configMap.put("plugins.security.ssl.http.pemkey_filepath", Certificates.NODE_KEY.getFileName());
        configMap.put("plugins.security.ssl.http.pemtrustedcas_filepath", Certificates.ROOT_CA.getFileName());
        configMap.put("plugins.security.allow_unsafe_democertificates", true);
        if (this.installer.initsecurity) {
            configMap.put("plugins.security.allow_default_init_securityindex", true);
        }
        configMap.put("plugins.security.authcz.admin_dn", List.of("CN=kirk,OU=client,O=client,L=test,C=de"));
        configMap.put("plugins.security.audit.type", "internal_opensearch");
        configMap.put("plugins.security.enable_snapshot_restore_privilege", true);
        configMap.put("plugins.security.check_snapshot_restore_write_privileges", true);
        configMap.put("plugins.security.restapi.roles_enabled", REST_ENABLED_ROLES);
        configMap.put("plugins.security.system_indices.enabled", true);
        configMap.put("plugins.security.system_indices.indices", SYSTEM_INDICES);
        if (!SecuritySettingsConfigurer.isNetworkHostAlreadyPresent(this.installer.OPENSEARCH_CONF_FILE) && this.installer.cluster_mode) {
            configMap.put("network.host", "0.0.0.0");
            configMap.put("node.name", "smoketestnode");
            configMap.put("cluster.initial_cluster_manager_nodes", "smoketestnode");
        }
        if (!SecuritySettingsConfigurer.isNodeMaxLocalStorageNodesAlreadyPresent(this.installer.OPENSEARCH_CONF_FILE)) {
            configMap.put("node.max_local_storage_nodes", 3);
        }
        return configMap;
    }

    static boolean isNetworkHostAlreadyPresent(String filePath) {
        try {
            String searchString = "network.host";
            return SecuritySettingsConfigurer.isKeyPresentInYMLFile(filePath, searchString);
        }
        catch (IOException e) {
            return false;
        }
    }

    static boolean isNodeMaxLocalStorageNodesAlreadyPresent(String filePath) {
        try {
            String searchString = "node.max_local_storage_nodes";
            return SecuritySettingsConfigurer.isKeyPresentInYMLFile(filePath, searchString);
        }
        catch (IOException e) {
            return false;
        }
    }

    static boolean isKeyPresentInYMLFile(String filePath, String key) throws IOException {
        JsonNode node;
        try {
            node = DefaultObjectMapper.YAML_MAPPER.readTree(new File(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return node.has(key);
    }

    void createSecurityAdminDemoScript(String securityAdminScriptPath, String securityAdminDemoScriptPath) throws IOException {
        String[] securityAdminCommands = this.getSecurityAdminCommands(securityAdminScriptPath);
        FileWriter writer = new FileWriter(securityAdminDemoScriptPath, StandardCharsets.UTF_8);
        for (String command : securityAdminCommands) {
            writer.write(command + System.lineSeparator());
        }
        writer.close();
    }

    String[] getSecurityAdminCommands(String securityAdminScriptPath) {
        String securityAdminExecutionPath = securityAdminScriptPath + "\" -cd \"" + this.installer.OPENSEARCH_CONF_DIR + "opensearch-security\" -icl -key \"" + this.installer.OPENSEARCH_CONF_DIR + Certificates.ADMIN_CERT_KEY.getFileName() + "\" -cert \"" + this.installer.OPENSEARCH_CONF_DIR + Certificates.ADMIN_CERT.getFileName() + "\" -cacert \"" + this.installer.OPENSEARCH_CONF_DIR + Certificates.ROOT_CA.getFileName() + "\" -nhnv";
        if (this.installer.OS.toLowerCase().contains("win")) {
            return new String[]{"@echo off", "call \"" + securityAdminExecutionPath};
        }
        return new String[]{"#!/bin/bash", "sudo \"" + securityAdminExecutionPath};
    }
}

