/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.securityconf.impl.AllowlistingSettings;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;

public class CType<T>
implements Comparable<CType<?>> {
    private static final Set<CType<?>> allSet = new HashSet();
    private static Map<String, CType<?>> nameToInstanceMap = new HashMap();
    private static Map<Integer, CType<?>> ordToInstanceMap = new HashMap();
    public static final CType<ActionGroupsV7> ACTIONGROUPS = new CType<ActionGroupsV7>("actiongroups", "action_groups", ActionGroupsV7.class, 0, false);
    public static final CType<AllowlistingSettings> ALLOWLIST = new CType<AllowlistingSettings>("allowlist", "allowlist", AllowlistingSettings.class, 1, true);
    public static final CType<AuditConfig> AUDIT = new CType<AuditConfig>("audit", "audit", AuditConfig.class, 2, true);
    public static final CType<ConfigV7> CONFIG = new CType<ConfigV7>("config", "config", ConfigV7.class, 3, false);
    public static final CType<InternalUserV7> INTERNALUSERS = new CType<InternalUserV7>("internalusers", "internal_users", InternalUserV7.class, 4, false);
    public static final CType<NodesDn> NODESDN = new CType<NodesDn>("nodesdn", "nodes_dn", NodesDn.class, 5, true);
    public static final CType<RoleV7> ROLES = new CType<RoleV7>("roles", "roles", RoleV7.class, 6, false);
    public static final CType<RoleMappingsV7> ROLESMAPPING = new CType<RoleMappingsV7>("rolesmapping", "roles_mapping", RoleMappingsV7.class, 7, false);
    public static final CType<TenantV7> TENANTS = new CType<TenantV7>("tenants", "tenants", TenantV7.class, 8, false);
    private final String name;
    private final String nameUpperCase;
    private final Class<T> configClass;
    private final String configFileName;
    private final boolean emptyIfMissing;
    private final int id;

    private CType(String name, String configFileName, Class<T> configClass, int id, boolean emptyIfMissing) {
        this.name = name;
        this.nameUpperCase = name.toUpperCase();
        this.configClass = configClass;
        this.id = id;
        this.configFileName = configFileName + ".yml";
        this.emptyIfMissing = emptyIfMissing;
        allSet.add(this);
        nameToInstanceMap.put(name, this);
        ordToInstanceMap.put(id, this);
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public boolean emptyIfMissing() {
        return this.emptyIfMissing;
    }

    public String toLCString() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public int getOrd() {
        return this.id;
    }

    public static CType<?> fromString(String value) {
        return nameToInstanceMap.get(value.toLowerCase());
    }

    public static Set<CType<?>> values() {
        return Collections.unmodifiableSet(allSet);
    }

    public static Set<String> lcStringValues() {
        return CType.values().stream().map(CType::toLCString).collect(Collectors.toSet());
    }

    public static Set<CType<?>> fromStringValues(String[] strings) {
        return Arrays.stream(strings).map(CType::fromString).collect(Collectors.toSet());
    }

    public static CType<?> fromOrd(int ord) {
        return ordToInstanceMap.get(ord);
    }

    public static Set<CType<?>> requiredConfigTypes() {
        return CType.values().stream().filter(Predicate.not(CType::emptyIfMissing)).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<CType<?>> notRequiredConfigTypes() {
        return CType.values().stream().filter(CType::emptyIfMissing).collect(Collectors.toUnmodifiableSet());
    }

    public Path configFile(Path configDir) {
        return configDir.resolve(this.configFileName);
    }

    public String configFileName() {
        return this.configFileName;
    }

    @Override
    public int compareTo(CType<?> cType) {
        return this.id - cType.id;
    }

    public String toString() {
        return this.nameUpperCase;
    }

    public boolean equals(Object other) {
        if (other instanceof CType) {
            return ((CType)other).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }
}

