/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.privileges.UserAttributes;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.HostResolverMode;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class ConfigModelV7
extends ConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private ConfigConstants.RolesMappingResolution rolesMappingResolution;
    private FlattenedActionGroups actionGroups;
    private TenantHolder tenantHolder;
    private RoleMappingHolder roleMappingHolder;
    private SecurityDynamicConfiguration<RoleV7> roles;
    private SecurityDynamicConfiguration<TenantV7> tenants;

    public ConfigModelV7(SecurityDynamicConfiguration<RoleV7> roles, SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, SecurityDynamicConfiguration<ActionGroupsV7> actiongroups, SecurityDynamicConfiguration<TenantV7> tenants, DynamicConfigModel dcm, Settings opensearchSettings) {
        this.roles = roles;
        this.tenants = tenants;
        try {
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.valueOf(opensearchSettings.get("plugins.security.roles_mapping_resolution", ConfigConstants.RolesMappingResolution.MAPPING_ONLY.toString()).toUpperCase());
        }
        catch (Exception e) {
            this.log.error("Cannot apply roles mapping resolution", (Throwable)e);
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.MAPPING_ONLY;
        }
        this.actionGroups = actiongroups != null ? new FlattenedActionGroups(actiongroups) : FlattenedActionGroups.EMPTY;
        this.tenantHolder = new TenantHolder(roles, tenants);
        this.roleMappingHolder = new RoleMappingHolder(rolemappings, dcm.getHostsResolverMode());
    }

    @Override
    public Set<String> getAllConfiguredTenantNames() {
        return Collections.unmodifiableSet(this.tenants.getCEntries().keySet());
    }

    @Override
    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.tenantHolder.mapTenants(user, roles);
    }

    @Override
    public Set<String> mapSecurityRoles(User user, TransportAddress caller) {
        return this.roleMappingHolder.map(user, caller);
    }

    private class TenantHolder {
        private SetMultimap<String, Tuple<String, Boolean>> tenantsMM = null;

        public TenantHolder(SecurityDynamicConfiguration<RoleV7> roles, final SecurityDynamicConfiguration<TenantV7> definedTenants) {
            HashSet<Future> futures = new HashSet<Future>(roles.getCEntries().size());
            ExecutorService execs = Executors.newFixedThreadPool(10);
            for (final Map.Entry<String, RoleV7> securityRole : roles.getCEntries().entrySet()) {
                if (securityRole.getValue() == null) continue;
                Future future = execs.submit(new Callable<Tuple<String, Set<Tuple<String, Boolean>>>>(){

                    @Override
                    public Tuple<String, Set<Tuple<String, Boolean>>> call() throws Exception {
                        HashSet<Tuple> tuples = new HashSet<Tuple>();
                        List<RoleV7.Tenant> tenants = ((RoleV7)securityRole.getValue()).getTenant_permissions();
                        if (tenants != null) {
                            for (RoleV7.Tenant tenant : tenants) {
                                List matchingTenants = WildcardMatcher.from(tenant.getTenant_patterns()).getMatchAny(definedTenants.getCEntries().keySet(), Collectors.toList());
                                for (String matchingTenant : matchingTenants) {
                                    tuples.add(new Tuple((Object)matchingTenant, (Object)ConfigModelV7.this.actionGroups.resolve(tenant.getAllowed_actions()).contains((Object)"kibana:saved_objects/*/write")));
                                }
                                Pattern parameterPattern = Pattern.compile("^\\$\\{attr");
                                List matchingParameterTenantList = tenant.getTenant_patterns().stream().filter(parameterPattern.asPredicate()).collect(Collectors.toList());
                                for (String matchingParameterTenant : matchingParameterTenantList) {
                                    tuples.add(new Tuple((Object)matchingParameterTenant, (Object)ConfigModelV7.this.actionGroups.resolve(tenant.getAllowed_actions()).contains((Object)"kibana:saved_objects/*/write")));
                                }
                            }
                        }
                        return new Tuple((Object)((String)securityRole.getKey()), tuples);
                    }
                });
                futures.add(future);
            }
            execs.shutdown();
            try {
                execs.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (1) while loading roles");
                return;
            }
            try {
                SetMultimap tenantsMM_ = MultimapBuilder.SetMultimapBuilder.hashKeys((int)futures.size()).hashSetValues(16).build();
                for (Future future : futures) {
                    Tuple result = (Tuple)future.get();
                    tenantsMM_.putAll((Object)((String)result.v1()), (Iterable)result.v2());
                }
                this.tenantsMM = tenantsMM_;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ConfigModelV7.this.log.error("Thread interrupted (2) while loading roles");
                return;
            }
            catch (ExecutionException e) {
                ConfigModelV7.this.log.error("Error while updating roles: {}", (Object)e.getCause(), (Object)e.getCause());
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }

        public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
            if (user == null || this.tenantsMM == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(roles.size());
            result.put(user.getName(), true);
            this.tenantsMM.entries().stream().filter(e -> roles.contains(e.getKey())).filter(e -> !user.getName().equals(((Tuple)e.getValue()).v1())).forEach(e -> {
                String tenant = UserAttributes.replaceProperties((String)((Tuple)e.getValue()).v1(), user);
                boolean rw = (Boolean)((Tuple)e.getValue()).v2();
                if ((rw || !result.containsKey(tenant)) && ConfigModelV7.this.tenants.getCEntries().containsKey(tenant)) {
                    result.put(tenant, rw);
                }
            });
            TreeSet<String> _roles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            _roles.addAll(roles);
            if (!result.containsKey("global_tenant") && (_roles.contains("kibana_user") || _roles.contains("all_access"))) {
                result.put("global_tenant", true);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private class RoleMappingHolder {
        private ListMultimap<String, String> users;
        private ListMultimap<List<WildcardMatcher>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private final String hostResolverMode;
        private List<WildcardMatcher> userMatchers;
        private List<WildcardMatcher> barMatchers;
        private List<WildcardMatcher> hostMatchers;

        private RoleMappingHolder(SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, String hostResolverMode) {
            this.hostResolverMode = hostResolverMode;
            if (ConfigModelV7.this.roles != null) {
                this.users = ArrayListMultimap.create();
                this.abars = ArrayListMultimap.create();
                this.bars = ArrayListMultimap.create();
                this.hosts = ArrayListMultimap.create();
                for (Map.Entry<String, RoleMappingsV7> roleMap : rolemappings.getCEntries().entrySet()) {
                    String roleMapKey = roleMap.getKey();
                    RoleMappingsV7 roleMapValue = roleMap.getValue();
                    for (String u : roleMapValue.getUsers()) {
                        this.users.put((Object)u, (Object)roleMapKey);
                    }
                    HashSet<String> abar = new HashSet<String>(roleMapValue.getAnd_backend_roles());
                    if (!abar.isEmpty()) {
                        this.abars.put(WildcardMatcher.matchers(abar), (Object)roleMapKey);
                    }
                    for (String bar : roleMapValue.getBackend_roles()) {
                        this.bars.put((Object)bar, (Object)roleMapKey);
                    }
                    for (String host : roleMapValue.getHosts()) {
                        this.hosts.put((Object)host, (Object)roleMapKey);
                    }
                }
                this.userMatchers = WildcardMatcher.matchers(this.users.keySet());
                this.barMatchers = WildcardMatcher.matchers(this.bars.keySet());
                this.hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> map(User user, TransportAddress caller) {
            if (user == null || this.users == null || this.abars == null || this.bars == null || this.hosts == null) {
                return Collections.emptySet();
            }
            HashSet<String> securityRoles = new HashSet<String>();
            Iterator<String> iterator = user.getSecurityRoles();
            synchronized (iterator) {
                securityRoles.addAll(user.getSecurityRoles());
            }
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BACKENDROLES_ONLY) {
                if (ConfigModelV7.this.log.isDebugEnabled()) {
                    ConfigModelV7.this.log.debug("Pass backendroles from {}", (Object)user);
                }
                securityRoles.addAll(user.getRoles());
            }
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.MAPPING_ONLY) {
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.userMatchers, user.getName())) {
                    securityRoles.addAll(this.users.get((Object)p2));
                }
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.barMatchers, user.getRoles())) {
                    securityRoles.addAll(this.bars.get((Object)p2));
                }
                for (Object patterns : this.abars.keySet()) {
                    if (!patterns.stream().allMatch(p -> p.matchAny(user.getRoles()))) continue;
                    securityRoles.addAll(this.abars.get(patterns));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    for (String p3 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, ipAddress)) {
                        securityRoles.addAll(this.hosts.get((Object)p3));
                    }
                    if (caller.address() != null && (this.hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME.getValue()) || this.hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME_LOOKUP.getValue()))) {
                        String hostName = caller.address().getHostString();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, hostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME_LOOKUP.getValue())) {
                        String resolvedHostName = caller.address().getHostName();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, resolvedHostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(securityRoles);
        }
    }
}

