/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.user.User;

public class UserAttributes {
    public static String replaceProperties(String orig, PrivilegesEvaluationContext context) {
        User user = context.getUser();
        orig = orig.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
        orig = UserAttributes.replaceRoles(orig, user);
        orig = UserAttributes.replaceSecurityRoles(orig, context);
        for (Map.Entry<String, String> entry : user.getCustomAttributesMap().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            orig = orig.replace("${" + entry.getKey() + "}", entry.getValue());
            orig = orig.replace("${" + entry.getKey().replace('.', '_') + "}", entry.getValue());
        }
        return orig;
    }

    private static String replaceSecurityRoles(String orig, PrivilegesEvaluationContext context) {
        String retVal = orig;
        if (orig.contains("${user.securityRoles}") || orig.contains("${user_securityRoles}")) {
            String commaSeparatedRoles = UserAttributes.toQuotedCommaSeparatedString((Set<String>)Sets.union(context.getUser().getSecurityRoles(), context.getMappedRoles()));
            retVal = orig.replace("${user.securityRoles}", commaSeparatedRoles).replace("${user_securityRoles}", commaSeparatedRoles);
        }
        return retVal;
    }

    @Deprecated
    public static String replaceProperties(String orig, User user) {
        if (user == null || orig == null) {
            return orig;
        }
        orig = orig.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
        orig = UserAttributes.replaceRoles(orig, user);
        orig = UserAttributes.replaceSecurityRoles(orig, user);
        for (Map.Entry<String, String> entry : user.getCustomAttributesMap().entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            orig = orig.replace("${" + entry.getKey() + "}", entry.getValue());
            orig = orig.replace("${" + entry.getKey().replace('.', '_') + "}", entry.getValue());
        }
        return orig;
    }

    private static String replaceRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.roles}") || orig.contains("${user_roles}")) {
            String commaSeparatedRoles = UserAttributes.toQuotedCommaSeparatedString(user.getRoles());
            retVal = orig.replace("${user.roles}", commaSeparatedRoles).replace("${user_roles}", commaSeparatedRoles);
        }
        return retVal;
    }

    @Deprecated
    private static String replaceSecurityRoles(String orig, User user) {
        String retVal = orig;
        if (orig.contains("${user.securityRoles}") || orig.contains("${user_securityRoles}")) {
            String commaSeparatedRoles = UserAttributes.toQuotedCommaSeparatedString(user.getSecurityRoles());
            retVal = orig.replace("${user.securityRoles}", commaSeparatedRoles).replace("${user_securityRoles}", commaSeparatedRoles);
        }
        return retVal;
    }

    private static String toQuotedCommaSeparatedString(Set<String> roles) {
        return Joiner.on((char)',').join(Iterables.transform(roles, s -> new StringBuilder(s.length() + 2).append('\"').append((String)s).append('\"').toString()));
    }
}

