/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.mapper.SeqNoFieldMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.shard.ShardUtils;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.compliance.ComplianceIndexingOperationListener;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.DlsFlsFilterLeafReader;
import org.opensearch.security.configuration.SystemIndexSearcherWrapper;
import org.opensearch.security.privileges.DocumentAllowList;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.dlsfls.DlsFlsBaseContext;
import org.opensearch.security.privileges.dlsfls.DlsFlsProcessedConfig;
import org.opensearch.security.privileges.dlsfls.DlsRestriction;
import org.opensearch.security.privileges.dlsfls.FieldMasking;
import org.opensearch.security.privileges.dlsfls.FieldPrivileges;

public class SecurityFlsDlsIndexSearcherWrapper
extends SystemIndexSearcherWrapper {
    public final Logger log = LogManager.getLogger(this.getClass());
    private final Set<String> metaFields;
    public static final Set<String> META_FIELDS_BEFORE_7DOT8 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_timestamp", "_ttl", "_type")));
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final AuditLog auditlog;
    private final LongSupplier nowInMillis;
    private final Supplier<DlsFlsProcessedConfig> dlsFlsProcessedConfigSupplier;
    private final DlsFlsBaseContext dlsFlsBaseContext;

    public SecurityFlsDlsIndexSearcherWrapper(IndexService indexService, Settings settings, AdminDNs adminDNs, ClusterService clusterService, AuditLog auditlog, ComplianceIndexingOperationListener ciol, PrivilegesEvaluator evaluator, Supplier<DlsFlsProcessedConfig> dlsFlsProcessedConfigSupplier, DlsFlsBaseContext dlsFlsBaseContext) {
        super(indexService, settings, adminDNs, evaluator);
        Set metadataFieldsCopy;
        if (indexService.getMetadata().getState() == IndexMetadata.State.CLOSE) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} was closed. Setting metadataFields to empty. Closed index is not searchable.", (Object)indexService.index().getName());
            }
            metadataFieldsCopy = Collections.emptySet();
        } else {
            metadataFieldsCopy = new HashSet(indexService.mapperService().getMetadataFields());
            SeqNoFieldMapper.SequenceIDFields sequenceIDFields = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
            metadataFieldsCopy.add(sequenceIDFields.primaryTerm.name());
            metadataFieldsCopy.addAll(META_FIELDS_BEFORE_7DOT8);
        }
        this.metaFields = metadataFieldsCopy;
        ciol.setIs(indexService);
        this.clusterService = clusterService;
        this.indexService = indexService;
        this.auditlog = auditlog;
        boolean allowNowinDlsQueries = settings.getAsBoolean("plugins.security.unsupported.allow_now_in_dls", Boolean.valueOf(false));
        this.nowInMillis = allowNowinDlsQueries ? () -> System.currentTimeMillis() : () -> {
            throw new IllegalArgumentException("'now' is not allowed in DLS queries");
        };
        this.log.debug("FLS/DLS {} enabled for index {}", (Object)this, (Object)indexService.index().getName());
        this.dlsFlsProcessedConfigSupplier = dlsFlsProcessedConfigSupplier;
        this.dlsFlsBaseContext = dlsFlsBaseContext;
    }

    @Override
    protected DirectoryReader dlsFlsWrap(DirectoryReader reader, boolean isAdmin) throws IOException {
        ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
        PrivilegesEvaluationContext privilegesEvaluationContext = this.dlsFlsBaseContext.getPrivilegesEvaluationContext();
        if (this.log.isTraceEnabled()) {
            this.log.trace("dlsFlsWrap(); index: {}; privilegeEvaluationContext: {}", (Object)this.index.getName(), (Object)privilegesEvaluationContext);
        }
        if (isAdmin || privilegesEvaluationContext == null) {
            return new DlsFlsFilterLeafReader.DlsFlsDirectoryReader(reader, FieldPrivileges.FlsRule.ALLOW_ALL, null, this.indexService, this.threadContext, this.clusterService, this.auditlog, FieldMasking.FieldMaskingRule.ALLOW_ALL, shardId, this.metaFields);
        }
        try {
            ConstantScoreQuery dlsQuery;
            DlsFlsProcessedConfig config = this.dlsFlsProcessedConfigSupplier.get();
            DlsRestriction dlsRestriction = !this.dlsFlsBaseContext.isDlsDoneOnFilterLevel() ? (DlsRestriction)config.getDocumentPrivileges().getRestriction(privilegesEvaluationContext, this.index.getName()) : DlsRestriction.NONE;
            FieldPrivileges.FlsRule flsRule = (FieldPrivileges.FlsRule)config.getFieldPrivileges().getRestriction(privilegesEvaluationContext, this.index.getName());
            FieldMasking.FieldMaskingRule fmRule = (FieldMasking.FieldMaskingRule)config.getFieldMasking().getRestriction(privilegesEvaluationContext, this.index.getName());
            if (dlsRestriction.isUnrestricted()) {
                dlsQuery = null;
            } else {
                QueryShardContext queryShardContext = this.indexService.newQueryShardContext(shardId.getId(), null, this.nowInMillis, null);
                dlsQuery = new ConstantScoreQuery((Query)dlsRestriction.toBooleanQueryBuilder(queryShardContext, null).build());
            }
            DocumentAllowList documentAllowList = DocumentAllowList.get(this.threadContext);
            if (documentAllowList.isEntryForIndexPresent(this.index.getName())) {
                if (!dlsRestriction.isUnrestricted() && documentAllowList.isAllowed(this.index.getName(), "*")) {
                    dlsRestriction = DlsRestriction.NONE;
                    this.log.debug("Lifting DLS for {} due to present document allowlist", (Object)this.index.getName());
                    dlsQuery = null;
                }
                if (!flsRule.isAllowAll() || !fmRule.isAllowAll()) {
                    this.log.debug("Lifting FLS/FM for {} due to present document allowlist", (Object)this.index.getName());
                    flsRule = FieldPrivileges.FlsRule.ALLOW_ALL;
                    fmRule = FieldMasking.FieldMaskingRule.ALLOW_ALL;
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("dlsFlsWrap(); index: {}; dlsRestriction: {}; flsRule: {}; fmRule: {}", (Object)this.index.getName(), (Object)dlsRestriction, (Object)flsRule, (Object)fmRule);
            }
            return new DlsFlsFilterLeafReader.DlsFlsDirectoryReader(reader, flsRule, (Query)dlsQuery, this.indexService, this.threadContext, this.clusterService, this.auditlog, fmRule, shardId, this.metaFields);
        }
        catch (PrivilegesEvaluationException e) {
            this.log.error("Error while evaluating DLS/FLS for {}", (Object)this.index.getName(), (Object)e);
            throw new OpenSearchException("Error while evaluating DLS/FLS", (Throwable)e, new Object[0]);
        }
    }
}

