/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap2;

import com.amazon.dlic.auth.ldap.LdapUser;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.pool.ConnectionPool;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.Destroyable;
import org.opensearch.security.auth.ldap.util.Utils;
import org.opensearch.security.auth.ldap2.LDAPConnectionFactoryFactory;
import org.opensearch.security.auth.ldap2.LDAPUserSearcher;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;
import org.opensearch.security.util.SettingsBasedSSLConfigurator;

public class LDAPAuthenticationBackend2
implements AuthenticationBackend,
Destroyable {
    protected static final Logger log = LogManager.getLogger(LDAPAuthenticationBackend2.class);
    private final Settings settings;
    private ConnectionPool connectionPool;
    private ConnectionFactory connectionFactory;
    private ConnectionFactory authConnectionFactory;
    private LDAPUserSearcher userSearcher;
    private final int customAttrMaxValueLen;
    private final WildcardMatcher whitelistedCustomLdapAttrMatcher;
    private final String[] returnAttributes;
    private final boolean shouldFollowReferrals;

    public LDAPAuthenticationBackend2(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        this.settings = settings;
        LDAPConnectionFactoryFactory ldapConnectionFactoryFactory = new LDAPConnectionFactoryFactory(settings, configPath);
        this.connectionPool = ldapConnectionFactoryFactory.createConnectionPool();
        this.connectionFactory = ldapConnectionFactoryFactory.createConnectionFactory(this.connectionPool);
        this.authConnectionFactory = this.connectionPool != null ? ldapConnectionFactoryFactory.createBasicConnectionFactory() : this.connectionFactory;
        this.userSearcher = new LDAPUserSearcher(settings);
        this.returnAttributes = settings.getAsList("custom_return_attributes", Arrays.asList(ReturnAttributes.ALL.value())).toArray(new String[0]);
        this.shouldFollowReferrals = settings.getAsBoolean("follow_referrals", Boolean.valueOf(true));
        this.customAttrMaxValueLen = settings.getAsInt("custom_attr_maxval_len", Integer.valueOf(36));
        this.whitelistedCustomLdapAttrMatcher = WildcardMatcher.from(settings.getAsList("custom_attr_whitelist", Collections.singletonList("*")));
    }

    @Override
    public User authenticate(final AuthCredentials credentials) throws OpenSearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<User>(){

                @Override
                public User run() throws Exception {
                    return LDAPAuthenticationBackend2.this.authenticate0(credentials);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof OpenSearchSecurityException) {
                throw (OpenSearchSecurityException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
    }

    private User authenticate0(AuthCredentials credentials) throws OpenSearchSecurityException {
        Connection ldapConnection = null;
        String user = credentials.getUsername();
        byte[] password = credentials.getPassword();
        try {
            ldapConnection = this.connectionFactory.getConnection();
            ldapConnection.open();
            LdapEntry entry = this.userSearcher.exists(ldapConnection, user, this.returnAttributes, this.shouldFollowReferrals);
            if (entry == null && this.settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue()) {
                String fakeLognDn = this.settings.get("fakelogin_dn", "CN=faketomakebindfail,DC=" + UUID.randomUUID().toString());
                entry = new LdapEntry(fakeLognDn);
                password = this.settings.get("fakelogin_password", "fakeLoginPwd123").getBytes(StandardCharsets.UTF_8);
            } else if (entry == null) {
                throw new OpenSearchSecurityException("No user " + user + " found", new Object[0]);
            }
            String dn = entry.getDn();
            if (log.isTraceEnabled()) {
                log.trace("Try to authenticate dn {}", (Object)dn);
            }
            if (this.connectionPool == null) {
                this.authenticateByLdapServer(ldapConnection, dn, password);
            } else {
                this.authenticateByLdapServerWithSeparateConnection(dn, password);
            }
            String usernameAttribute = this.settings.get("username_attribute", null);
            String username = dn;
            if (usernameAttribute != null && entry.getAttribute(usernameAttribute) != null) {
                username = Utils.getSingleStringValue(entry.getAttribute(usernameAttribute));
            }
            if (log.isDebugEnabled()) {
                log.debug("Authenticated username {}", (Object)username);
            }
            LdapUser ldapUser = new LdapUser(username, user, entry, credentials, this.customAttrMaxValueLen, this.whitelistedCustomLdapAttrMatcher);
            return ldapUser;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to authenticate user due to ", (Throwable)e);
            }
            throw new OpenSearchSecurityException(e.toString(), e, new Object[0]);
        }
        finally {
            Arrays.fill(password, (byte)0);
            password = null;
            Utils.unbindAndCloseSilently(ldapConnection);
        }
    }

    @Override
    public String getType() {
        return "ldap";
    }

    @Override
    public boolean exists(final User user) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return LDAPAuthenticationBackend2.this.exists0(user);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists0(User user) {
        Connection ldapConnection = null;
        String userName = user.getName();
        if (user instanceof LdapUser) {
            userName = ((LdapUser)user).getUserEntry().getDn();
        }
        try {
            boolean exists;
            ldapConnection = this.connectionFactory.getConnection();
            ldapConnection.open();
            LdapEntry userEntry = this.userSearcher.exists(ldapConnection, userName, this.returnAttributes, this.shouldFollowReferrals);
            boolean bl = exists = userEntry != null;
            if (exists) {
                user.addAttributes(LdapUser.extractLdapAttributes(userName, userEntry, this.customAttrMaxValueLen, this.whitelistedCustomLdapAttrMatcher));
            }
            boolean bl2 = exists;
            return bl2;
        }
        catch (Exception e) {
            log.warn("User {} does not exist due to exception", (Object)userName, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.unbindAndCloseSilently(ldapConnection);
        }
    }

    private void authenticateByLdapServer(final Connection connection, final String dn, final byte[] password) throws LdapException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Response<Void>>(){

                @Override
                public Response<Void> run() throws LdapException {
                    return connection.getProviderConnection().bind(new BindRequest(dn, new Credential(password)));
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof LdapException) {
                throw (LdapException)((Object)e.getException());
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e);
        }
    }

    private void authenticateByLdapServerWithSeparateConnection(String dn, byte[] password) throws LdapException {
        try (Connection unpooledConnection = this.authConnectionFactory.getConnection();){
            unpooledConnection.open();
            this.authenticateByLdapServer(unpooledConnection, dn, password);
        }
    }

    @Override
    public void destroy() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
            this.connectionPool = null;
        }
    }
}

