/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BaseAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.client.Client;

public final class ParseUtils {
    private static final Logger logger = LogManager.getLogger(ParseUtils.class);

    private ParseUtils() {
    }

    public static Instant toInstant(XContentParser parser) throws IOException {
        if (parser.currentToken() == null || parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken().isValue()) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        return null;
    }

    public static AggregationBuilder toAggregationBuilder(XContentParser parser) throws IOException {
        AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((XContentParser)parser);
        return (AggregationBuilder)parsed.getAggregatorFactories().iterator().next();
    }

    public static XContentParser parser(String content, NamedXContentRegistry contentRegistry) throws IOException {
        XContentParser parser = XContentType.JSON.xContent().createParser(contentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, content);
        parser.nextToken();
        return parser;
    }

    public static AggregatorFactories.Builder parseAggregators(String aggQuery, NamedXContentRegistry xContentRegistry, String aggName) throws IOException {
        XContentParser parser = ParseUtils.parser(aggQuery, xContentRegistry);
        return ParseUtils.parseAggregators(parser, aggName);
    }

    public static AggregatorFactories.Builder parseAggregators(XContentParser parser, String aggName) throws IOException {
        return ParseUtils.parseAggregators(parser, 0, aggName);
    }

    public static AggregatorFactories.Builder parseAggregators(XContentParser parser, int level, String aggName) throws IOException {
        Matcher validAggMatcher = AggregatorFactories.VALID_AGG_NAME.matcher("");
        AggregatorFactories.Builder factories = new AggregatorFactories.Builder();
        XContentParser.Token token = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String aggregationName;
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [aggs]: aggregations definitions must start with the name of the aggregation.", new Object[0]);
            }
            String string = aggregationName = aggName == null ? parser.currentName() : aggName;
            if (!validAggMatcher.reset(aggregationName).matches()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid aggregation name [" + aggregationName + "]. Aggregation names must be alpha-numeric and can only contain '_' and '-'", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Aggregation definition for [" + aggregationName + " starts with a [" + String.valueOf(token) + "], expected a [" + String.valueOf(XContentParser.Token.START_OBJECT) + "].", new Object[0]);
            }
            BaseAggregationBuilder aggBuilder = null;
            AggregatorFactories.Builder subFactories = null;
            Map metaData = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.FIELD_NAME) + "] under a [" + String.valueOf(XContentParser.Token.START_OBJECT) + "], but got a [" + String.valueOf(token) + "] in [" + aggregationName + "]", new Object[]{parser.getTokenLocation()});
                }
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (fieldName) {
                        case "meta": {
                            metaData = parser.map();
                            break;
                        }
                        case "aggregations": 
                        case "aggs": {
                            if (subFactories != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two sub aggregation definitions under [" + aggregationName + "]", new Object[0]);
                            }
                            subFactories = ParseUtils.parseAggregators(parser, level + 1, null);
                            break;
                        }
                        default: {
                            if (aggBuilder != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two aggregation type definitions in [" + aggregationName + "]: [" + aggBuilder.getType() + "] and [" + fieldName + "]", new Object[0]);
                            }
                            aggBuilder = (BaseAggregationBuilder)parser.namedObject(BaseAggregationBuilder.class, fieldName, (Object)aggregationName);
                            break;
                        }
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] under [" + fieldName + "], but got a [" + String.valueOf(token) + "] in [" + aggregationName + "]", new Object[0]);
            }
            if (aggBuilder == null) {
                throw new ParsingException(parser.getTokenLocation(), "Missing definition for aggregation [" + aggregationName + "]", new Object[]{parser.getTokenLocation()});
            }
            if (metaData != null) {
                aggBuilder.setMetadata(metaData);
            }
            if (subFactories != null) {
                aggBuilder.subAggregations(subFactories);
            }
            if (aggBuilder instanceof AggregationBuilder) {
                factories.addAggregator((AggregationBuilder)aggBuilder);
                continue;
            }
            factories.addPipelineAggregator((PipelineAggregationBuilder)aggBuilder);
        }
        return factories;
    }

    public static SearchSourceBuilder generateInternalFeatureQuery(Config config, long startTime, long endTime, NamedXContentRegistry xContentRegistry) throws IOException {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(config.getTimeField()).from((Object)startTime).to((Object)endTime).format("epoch_millis").includeLower(true).includeUpper(false);
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery).must(config.getFilterQuery());
        SearchSourceBuilder internalSearchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery);
        if (config.getFeatureAttributes() != null) {
            for (Feature feature : config.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                internalSearchSourceBuilder.aggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return internalSearchSourceBuilder;
    }

    public static SearchSourceBuilder generateRangeQuery(Config config, List<Map.Entry<Long, Long>> ranges, NamedXContentRegistry xContentRegistry) throws IOException {
        DateRangeAggregationBuilder dateRangeBuilder = (DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"date_range").field(config.getTimeField())).format("epoch_millis");
        for (Map.Entry<Long, Long> range : ranges) {
            dateRangeBuilder.addRange((double)range.getKey().longValue(), (double)range.getValue().longValue());
        }
        if (config.getFeatureAttributes() != null) {
            for (Feature feature : config.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                dateRangeBuilder.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return new SearchSourceBuilder().query(config.getFilterQuery()).size(0).aggregation((AggregationBuilder)dateRangeBuilder);
    }

    public static SearchSourceBuilder generateColdStartQuery(Config config, List<Map.Entry<Long, Long>> ranges, Optional<Entity> entity, NamedXContentRegistry xContentRegistry) throws IOException {
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().filter(config.getFilterQuery());
        if (entity.isPresent()) {
            for (TermQueryBuilder term : entity.get().getTermQueryForCustomerIndex()) {
                internalFilterQuery.filter((QueryBuilder)term);
            }
        }
        DateRangeAggregationBuilder dateRangeBuilder = (DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"date_range").field(config.getTimeField())).format("epoch_millis");
        for (Map.Entry<Long, Long> range : ranges) {
            dateRangeBuilder.addRange((double)range.getKey().longValue(), (double)range.getValue().longValue());
        }
        if (config.getFeatureAttributes() != null) {
            for (Feature feature : config.getFeatureAttributes()) {
                AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
                dateRangeBuilder.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            }
        }
        return new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).size(0).aggregation((AggregationBuilder)dateRangeBuilder);
    }

    public static SearchSourceBuilder generateColdStartQueryForSingleFeature(Config config, List<Map.Entry<Long, Long>> ranges, Optional<Entity> entity, NamedXContentRegistry xContentRegistry, int featureIndex) throws IOException {
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().filter(config.getFilterQuery());
        if (entity.isPresent()) {
            for (TermQueryBuilder termQueryBuilder : entity.get().getTermQueryForCustomerIndex()) {
                internalFilterQuery.filter((QueryBuilder)termQueryBuilder);
            }
        }
        DateRangeAggregationBuilder dateRangeBuilder = (DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)"date_range").field(config.getTimeField())).format("epoch_millis");
        for (Map.Entry<Long, Long> entry : ranges) {
            dateRangeBuilder.addRange((double)entry.getKey().longValue(), (double)entry.getValue().longValue());
        }
        if (config.getFeatureAttributes() == null) {
            throw new IllegalArgumentException("empty feature");
        }
        Feature feature = config.getFeatureAttributes().get(featureIndex);
        AggregatorFactories.Builder builder = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
        dateRangeBuilder.subAggregation((AggregationBuilder)builder.getAggregatorFactories().iterator().next());
        return new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).size(0).aggregation((AggregationBuilder)dateRangeBuilder);
    }

    public static List<FeatureData> getFeatureData(double[] currentFeature, Config config) {
        List<String> featureIds = config.getEnabledFeatureIds();
        List<String> featureNames = config.getEnabledFeatureNames();
        int featureLen = featureIds.size();
        ArrayList<FeatureData> featureData = new ArrayList<FeatureData>();
        for (int i = 0; i < featureLen; ++i) {
            featureData.add(new FeatureData(featureIds.get(i), featureNames.get(i), currentFeature[i]));
        }
        return featureData;
    }

    public static SearchSourceBuilder addUserBackendRolesFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        if (user == null) {
            return searchSourceBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        String userFieldName = "user";
        String userBackendRoleFieldName = "user.backend_roles.keyword";
        Object backendRoles = user.getBackendRoles() != null ? user.getBackendRoles() : ImmutableList.of();
        TermsQueryBuilder userRolesFilterQuery = QueryBuilders.termsQuery((String)userBackendRoleFieldName, (Collection)backendRoles);
        NestedQueryBuilder nestedQueryBuilder = new NestedQueryBuilder(userFieldName, (QueryBuilder)userRolesFilterQuery, ScoreMode.None);
        boolQueryBuilder.must((QueryBuilder)nestedQueryBuilder);
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (query instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)query).filter((QueryBuilder)boolQueryBuilder);
        } else {
            throw new TimeSeriesException("Search API does not support queries other than BoolQuery");
        }
        return searchSourceBuilder;
    }

    public static User getUserContext(Client client) {
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        logger.debug("Filtering result by " + userStr);
        return User.parse((String)userStr);
    }

    public static <ConfigType extends Config, GetConfigResponseType extends ActionResponse> void resolveUserAndExecute(User requestedUser, String configId, boolean filterByEnabled, ActionListener listener, Consumer<ConfigType> function, Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Class<ConfigType> configTypeClass) {
        try {
            if (requestedUser == null || configId == null) {
                function.accept(null);
            } else {
                ParseUtils.getConfig(requestedUser, configId, listener, function, client, clusterService, xContentRegistry, filterByEnabled, configTypeClass);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static <ConfigType extends Config, GetConfigResponseType extends ActionResponse> void getConfig(User requestUser, String configId, ActionListener<GetConfigResponseType> listener, Consumer<ConfigType> function, Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry, boolean filterByBackendRole, Class<ConfigType> configTypeClass) {
        if (clusterService.state().metadata().indices().containsKey(".opendistro-anomaly-detectors")) {
            GetRequest request = new GetRequest(".opendistro-anomaly-detectors").id(configId);
            client.get(request, ActionListener.wrap(response -> ParseUtils.onGetConfigResponse(response, requestUser, configId, listener, function, xContentRegistry, filterByBackendRole, configTypeClass), exception -> {
                logger.error("Failed to get config: " + configId, (Throwable)exception);
                listener.onFailure(exception);
            }));
        } else {
            listener.onFailure((Exception)new IndexNotFoundException(".opendistro-anomaly-detectors"));
        }
    }

    public static <ConfigType extends Config, GetConfigResponseType extends ActionResponse> void onGetConfigResponse(GetResponse response, User requestUser, String configId, ActionListener<GetConfigResponseType> listener, Consumer<ConfigType> function, NamedXContentRegistry xContentRegistry, boolean filterByBackendRole, Class<ConfigType> configTypeClass) {
        if (response.isExists()) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                Config config = Config.parseConfig(configTypeClass, parser);
                User resourceUser = config.getUser();
                if (!filterByBackendRole || ParseUtils.checkUserPermissions(requestUser, resourceUser, configId) || ParseUtils.isAdmin(requestUser)) {
                    function.accept(config);
                } else {
                    logger.debug("User: " + requestUser.getName() + " does not have permissions to access config: " + configId);
                    listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.NO_PERMISSION_TO_ACCESS_CONFIG + configId, RestStatus.FORBIDDEN, new Object[0]));
                }
            }
            catch (Exception e) {
                logger.error("Fail to parse user out of config", (Throwable)e);
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_GET_USER_INFO + configId, RestStatus.BAD_REQUEST, new Object[0]));
            }
        } else {
            listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
        }
    }

    public static boolean isAdmin(User user) {
        if (user == null) {
            return false;
        }
        return user.getRoles().contains("all_access");
    }

    private static boolean checkUserPermissions(User requestedUser, User resourceUser, String configId) throws Exception {
        if (resourceUser.getBackendRoles() == null || requestedUser.getBackendRoles() == null) {
            return false;
        }
        for (String backendRole : requestedUser.getBackendRoles()) {
            if (!resourceUser.getBackendRoles().contains(backendRole)) continue;
            logger.debug("User: " + requestedUser.getName() + " has backend role: " + backendRole + " permissions to access config: " + configId);
            return true;
        }
        return false;
    }

    public static String checkFilterByBackendRoles(User requestedUser) {
        if (requestedUser == null) {
            return "Filter by backend roles is enabled and User is null";
        }
        if (requestedUser.getBackendRoles().isEmpty()) {
            return String.format(Locale.ROOT, "Filter by backend roles is enabled and User %s does not have backend roles configured", requestedUser.getName());
        }
        return null;
    }

    public static Optional<Long> getLatestDataTime(SearchResponse searchResponse) {
        return Optional.ofNullable(searchResponse).map(SearchResponse::getAggregations).map(aggs -> aggs.asMap()).map(map -> (Max)map.get("max_timefield")).filter(agg -> agg != null && agg.getValue() > 0.0).map(agg -> (long)agg.getValue());
    }

    public static SearchSourceBuilder batchFeatureQuery(Config config, Entity entity, long startTime, long endTime, NamedXContentRegistry xContentRegistry) throws IOException {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(config.getTimeField()).from((Object)startTime).to((Object)endTime).format("epoch_millis").includeLower(true).includeUpper(false);
        BoolQueryBuilder internalFilterQuery = QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery).must(config.getFilterQuery());
        if (config.isHighCardinality() && entity != null && entity.getAttributes().size() > 0) {
            entity.getAttributes().entrySet().forEach(attr -> internalFilterQuery.filter((QueryBuilder)new TermQueryBuilder((String)attr.getKey(), (String)attr.getValue())));
        }
        long intervalSeconds = ((IntervalTimeConfiguration)config.getInterval()).toDuration().getSeconds();
        ArrayList<DateHistogramValuesSourceBuilder> sources = new ArrayList<DateHistogramValuesSourceBuilder>();
        sources.add(((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder("date_histogram").field(config.getTimeField())).fixedInterval(DateHistogramInterval.seconds((int)((int)intervalSeconds))));
        CompositeAggregationBuilder aggregationBuilder = new CompositeAggregationBuilder("feature_aggs", sources).size(10000);
        if (config.getEnabledFeatureIds().size() == 0) {
            throw new TimeSeriesException("No enabled feature configured").countedInStats(false);
        }
        for (Feature feature : config.getFeatureAttributes()) {
            if (!feature.getEnabled().booleanValue()) continue;
            AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
            aggregationBuilder.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchSourceBuilder.query((QueryBuilder)internalFilterQuery);
        searchSourceBuilder.size(0);
        return searchSourceBuilder;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <S, T> boolean isNullOrEmpty(Map<S, T> map) {
        return map == null || map.size() == 0;
    }

    public static boolean listEqualsWithoutConsideringOrder(List<String> list1, List<String> list2) {
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        if (list1 != null) {
            set1.addAll(list1);
        }
        if (list2 != null) {
            set2.addAll(list2);
        }
        return Objects.equals(set1, set2);
    }

    public static double[] parseDoubleArray(XContentParser parser) throws IOException {
        ArrayList<Double> oldValList = new ArrayList<Double>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            oldValList.add(parser.doubleValue());
        }
        return oldValList.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public static List<String> parseAggregationRequest(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<String> fieldNames = new ArrayList<String>();
        block6: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String field;
            if (token != XContentParser.Token.FIELD_NAME) continue;
            switch (field = parser.currentName()) {
                case "field": {
                    parser.nextToken();
                    fieldNames.add(parser.textOrNull());
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        return fieldNames;
    }

    public static List<String> getFeatureFieldNames(Config config, NamedXContentRegistry xContentRegistry) throws IOException {
        ArrayList<String> featureFields = new ArrayList<String>();
        for (Feature feature : config.getFeatureAttributes()) {
            featureFields.add(ParseUtils.getFieldNamesForFeature(feature, xContentRegistry).get(0));
        }
        return featureFields;
    }

    public static List<String> getFieldNamesForFeature(Feature feature, NamedXContentRegistry xContentRegistry) throws IOException {
        ParseUtils.parseAggregators(feature.getAggregation().toString(), xContentRegistry, feature.getId());
        XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, feature.getAggregation().toString());
        parser.nextToken();
        return ParseUtils.parseAggregationRequest(parser);
    }
}

