/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.caching;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.timeseries.ExpiringState;
import org.opensearch.timeseries.MaintenanceState;

public class DoorKeeper
implements MaintenanceState,
ExpiringState {
    private final Logger LOG = LogManager.getLogger(DoorKeeper.class);
    private final long expectedInsertions;
    private Map<String, Integer> frequencyMap;
    private Instant lastMaintenanceTime;
    private final Duration resetInterval;
    private final Clock clock;
    private Instant lastAccessTime;
    private final int countThreshold;

    public DoorKeeper(long expectedInsertions, Duration resetInterval, Clock clock, int countThreshold) {
        this.expectedInsertions = expectedInsertions;
        this.resetInterval = resetInterval;
        this.clock = clock;
        this.countThreshold = countThreshold;
        this.lastAccessTime = clock.instant();
        this.maintenance();
    }

    public void put(String modelId) {
        this.lastAccessTime = this.clock.instant();
        this.frequencyMap.put(modelId, this.frequencyMap.getOrDefault(modelId, 0) + 1);
        if ((long)this.frequencyMap.size() > this.expectedInsertions) {
            this.reset();
        }
    }

    @Override
    public void maintenance() {
        if (this.frequencyMap == null || this.lastMaintenanceTime.plus(this.resetInterval).isBefore(this.clock.instant())) {
            this.LOG.debug("maintaining for doorkeeper");
            this.reset();
        }
    }

    private void reset() {
        this.frequencyMap = new HashMap<String, Integer>();
        this.lastMaintenanceTime = this.clock.instant();
    }

    public boolean appearsMoreThanOrEqualToThreshold(String item) {
        this.lastAccessTime = this.clock.instant();
        return this.frequencyMap.getOrDefault(item, 0) >= this.countThreshold;
    }

    @Override
    public boolean expired(Duration stateTtl) {
        return this.expired(this.lastAccessTime, this.resetInterval, this.clock.instant());
    }
}

