/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resolver;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.datastream.CreateDataStreamAction;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.resolve.ResolveIndexAction;
import org.opensearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.main.MainRequest;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.action.termvectors.MultiTermVectorsRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.index.Index;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.support.SnapshotRestoreHelper;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotUtils;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.TransportRequest;

public class IndexResolverReplacer {
    private static final Set<String> NULL_SET = new HashSet<Object>(Collections.singleton(null));
    private final Logger log = LogManager.getLogger(this.getClass());
    private final IndexNameExpressionResolver resolver;
    private final ClusterService clusterService;
    private final ClusterInfoHolder clusterInfoHolder;
    private volatile boolean respectRequestIndicesOptions = false;

    public IndexResolverReplacer(IndexNameExpressionResolver resolver, ClusterService clusterService, ClusterInfoHolder clusterInfoHolder) {
        this.resolver = resolver;
        this.clusterService = clusterService;
        this.clusterInfoHolder = clusterInfoHolder;
    }

    private static final boolean isAllWithNoRemote(String ... requestedPatterns) {
        List<String> patterns;
        List<String> list = patterns = requestedPatterns == null ? null : Arrays.asList(requestedPatterns);
        if (IndexNameExpressionResolver.isAllIndices(patterns)) {
            return true;
        }
        if (patterns.size() == 1 && patterns.contains("*")) {
            return true;
        }
        return new HashSet<String>(patterns).equals(NULL_SET);
    }

    private static final boolean isLocalAll(String ... requestedPatterns) {
        return IndexResolverReplacer.isLocalAll(requestedPatterns == null ? null : Arrays.asList(requestedPatterns));
    }

    private static final boolean isLocalAll(Collection<String> patterns) {
        if (IndexNameExpressionResolver.isAllIndices(patterns)) {
            return true;
        }
        if (patterns.contains("_all")) {
            return true;
        }
        return new HashSet<String>(patterns).equals(NULL_SET);
    }

    public boolean replace(TransportRequest request, final boolean retainMode, final String ... replacements) {
        return this.getOrReplaceAllIndices(request, new IndicesProvider(){

            @Override
            public String[] provide(String[] original, Object request, boolean supportsReplace) {
                if (supportsReplace) {
                    if (retainMode && !IndexResolverReplacer.isAllWithNoRemote(original)) {
                        Resolved resolved = IndexResolverReplacer.this.resolveRequest(request);
                        List<String> retained = WildcardMatcher.from(resolved.getAllIndices()).getMatchAny(replacements, Collectors.toList());
                        retained.addAll(resolved.getRemoteIndices());
                        return retained.toArray(new String[0]);
                    }
                    return replacements;
                }
                return NOOP;
            }
        }, false);
    }

    public Resolved resolveRequest(Object request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolve aliases, indices and types from {}", (Object)request.getClass().getSimpleName());
        }
        ResolvedIndicesProvider resolvedIndicesProvider = new ResolvedIndicesProvider(request);
        this.getOrReplaceAllIndices(request, resolvedIndicesProvider, false);
        return resolvedIndicesProvider.resolved(this.indicesOptionsFrom(request));
    }

    private List<String> renamedIndices(RestoreSnapshotRequest request, List<String> filteredIndices) {
        try {
            ArrayList<String> renamedIndices = new ArrayList<String>();
            Iterator<String> iterator = filteredIndices.iterator();
            while (iterator.hasNext()) {
                String index;
                String renamedIndex = index = iterator.next();
                if (request.renameReplacement() != null && request.renamePattern() != null) {
                    renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
                }
                renamedIndices.add(renamedIndex);
            }
            return renamedIndices;
        }
        catch (PatternSyntaxException e) {
            this.log.error("Unable to parse the regular expression denoted in 'rename_pattern'. Please correct the pattern an try again.");
            throw e;
        }
    }

    private boolean checkIndices(Object request, String[] indices, boolean needsToBeSizeOne, boolean allowEmpty) {
        if (indices == IndicesProvider.NOOP) {
            return false;
        }
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (!(allowEmpty || indices != null && indices.length != 0)) {
            if (isTraceEnabled && request != null) {
                this.log.trace("Null or empty indices for " + request.getClass().getName());
            }
            return false;
        }
        if (!allowEmpty && needsToBeSizeOne && indices.length != 1) {
            if (isTraceEnabled && request != null) {
                this.log.trace("To much indices for " + request.getClass().getName());
            }
            return false;
        }
        for (int i = 0; i < indices.length; ++i) {
            String index = indices[i];
            if (index != null && !index.isEmpty()) continue;
            if (isTraceEnabled && request != null) {
                this.log.trace("At least one null or empty index for " + request.getClass().getName());
            }
            return false;
        }
        return true;
    }

    private boolean getOrReplaceAllIndices(Object request, IndicesProvider provider, boolean allowEmptyIndices) {
        boolean isDebugEnabled = this.log.isDebugEnabled();
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("getOrReplaceAllIndices() for " + request.getClass());
        }
        boolean result = true;
        if (request instanceof BulkRequest) {
            for (DocWriteRequest ar : ((BulkRequest)request).requests()) {
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof MultiGetRequest) {
            ListIterator it = ((MultiGetRequest)request).getItems().listIterator();
            while (it.hasNext()) {
                MultiGetRequest.Item item = (MultiGetRequest.Item)it.next();
                result = this.getOrReplaceAllIndices(item, provider, false) && result;
            }
        } else if (request instanceof MultiSearchRequest) {
            ListIterator it = ((MultiSearchRequest)request).requests().listIterator();
            while (it.hasNext()) {
                SearchRequest ar = (SearchRequest)it.next();
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof MultiTermVectorsRequest) {
            for (ActionRequest ar : () -> ((MultiTermVectorsRequest)request).iterator()) {
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof PutMappingRequest) {
            PutMappingRequest pmr = (PutMappingRequest)request;
            Index concreteIndex = pmr.getConcreteIndex();
            if (concreteIndex != null && (pmr.indices() == null || pmr.indices().length == 0)) {
                String[] newIndices = provider.provide(new String[]{concreteIndex.getName()}, request, true);
                if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                    return false;
                }
                ((PutMappingRequest)request).indices(newIndices);
                ((PutMappingRequest)request).setConcreteIndex(null);
            } else {
                String[] newIndices = provider.provide(((PutMappingRequest)request).indices(), request, true);
                if (!this.checkIndices(request, newIndices, false, allowEmptyIndices)) {
                    return false;
                }
                ((PutMappingRequest)request).indices(newIndices);
            }
        } else if (request instanceof RestoreSnapshotRequest) {
            if (this.clusterInfoHolder.isLocalNodeElectedClusterManager() == Boolean.FALSE) {
                return true;
            }
            RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
            SnapshotInfo snapshotInfo = SnapshotRestoreHelper.getSnapshotInfo(restoreRequest);
            if (snapshotInfo == null) {
                this.log.warn("snapshot repository '" + restoreRequest.repository() + "', snapshot '" + restoreRequest.snapshot() + "' not found");
                provider.provide(new String[]{"*"}, request, false);
            } else {
                List requestedResolvedIndices = SnapshotUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
                List<String> renamedTargetIndices = this.renamedIndices(restoreRequest, requestedResolvedIndices);
                if (isDebugEnabled) {
                    this.log.debug("snapshot: {} contains this indices: {}", (Object)snapshotInfo.snapshotId().getName(), renamedTargetIndices);
                }
                provider.provide(renamedTargetIndices.toArray(new String[0]), request, false);
            }
        } else if (request instanceof IndicesAliasesRequest) {
            for (IndicesAliasesRequest.AliasActions ar : ((IndicesAliasesRequest)request).getAliasActions()) {
                result = this.getOrReplaceAllIndices(ar, provider, false) && result;
            }
        } else if (request instanceof DeleteRequest) {
            String[] newIndices = provider.provide(((DeleteRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((DeleteRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof UpdateRequest) {
            String[] newIndices = provider.provide(((UpdateRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((UpdateRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof SingleShardRequest) {
            String[] stringArray;
            SingleShardRequest singleShardRequest = (SingleShardRequest)request;
            String index = singleShardRequest.index();
            if (index == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = index;
            }
            String[] indices = provider.provide(stringArray, request, true);
            if (!this.checkIndices(request, indices, true, allowEmptyIndices)) {
                return false;
            }
            singleShardRequest.index(indices.length != 1 ? null : indices[0]);
        } else if (request instanceof FieldCapabilitiesIndexRequest) {
            FieldCapabilitiesIndexRequest fieldCapabilitiesRequest = (FieldCapabilitiesIndexRequest)request;
            String index = fieldCapabilitiesRequest.index();
            String[] newIndices = provider.provide(new String[]{index}, request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
        } else if (request instanceof IndexRequest) {
            String[] newIndices = provider.provide(((IndexRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((IndexRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof IndicesRequest.Replaceable) {
            String[] newIndices = provider.provide(((IndicesRequest.Replaceable)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, false, allowEmptyIndices)) {
                return false;
            }
            ((IndicesRequest.Replaceable)request).indices(newIndices);
        } else if (request instanceof BulkShardRequest) {
            provider.provide(((ReplicationRequest)request).indices(), request, false);
        } else if (request instanceof ReplicationRequest) {
            String[] newIndices = provider.provide(((ReplicationRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((ReplicationRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof MultiGetRequest.Item) {
            String[] newIndices = provider.provide(((MultiGetRequest.Item)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((MultiGetRequest.Item)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof CreateIndexRequest) {
            String[] newIndices = provider.provide(((CreateIndexRequest)request).indices(), request, true);
            if (!this.checkIndices(request, newIndices, true, allowEmptyIndices)) {
                return false;
            }
            ((CreateIndexRequest)request).index(newIndices.length != 1 ? null : newIndices[0]);
        } else if (request instanceof CreateDataStreamAction.Request) {
            provider.provide(((CreateDataStreamAction.Request)request).indices(), request, false);
        } else if (request instanceof ReindexRequest) {
            result = this.getOrReplaceAllIndices(((ReindexRequest)request).getDestination(), provider, false) && result;
            result = this.getOrReplaceAllIndices(((ReindexRequest)request).getSearchRequest(), provider, false) && result;
        } else if (!(request instanceof BaseNodesRequest || request instanceof MainRequest || request instanceof ClearScrollRequest || request instanceof SearchScrollRequest || request instanceof PutComponentTemplateAction.Request)) {
            if (isDebugEnabled) {
                this.log.debug(request.getClass() + " not supported (It is likely not a indices related request)");
            }
            result = false;
        }
        return result;
    }

    private IndicesOptions indicesOptionsFrom(Object localRequest) {
        if (!this.respectRequestIndicesOptions) {
            return IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true);
        }
        if (IndicesRequest.class.isInstance(localRequest)) {
            return ((IndicesRequest)localRequest).indicesOptions();
        }
        if (RestoreSnapshotRequest.class.isInstance(localRequest)) {
            return ((RestoreSnapshotRequest)localRequest).indicesOptions();
        }
        return IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true);
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.respectRequestIndicesOptions = dcm.isRespectRequestIndicesEnabled();
    }

    @FunctionalInterface
    public static interface IndicesProvider {
        public static final String[] NOOP = new String[0];

        public String[] provide(String[] var1, Object var2, boolean var3);
    }

    private class ResolvedIndicesProvider
    implements IndicesProvider {
        private final ImmutableSet.Builder<String> aliases = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> allIndices = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> originalRequested = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> remoteIndices = ImmutableSet.builder();
        private final Set<MultiKey> alreadyResolved = new HashSet<MultiKey>();
        private final String name;

        ResolvedIndicesProvider(Object request) {
            this.name = request.getClass().getSimpleName();
        }

        private void resolveIndexPatterns(String name, IndicesOptions indicesOptions, boolean enableCrossClusterResolution, String[] original) {
            Object matchingAllIndices;
            Object matchingAliases;
            Set<String> remoteIndices;
            boolean isTraceEnabled = IndexResolverReplacer.this.log.isTraceEnabled();
            if (isTraceEnabled) {
                IndexResolverReplacer.this.log.trace("resolve requestedPatterns: " + Arrays.toString(original));
            }
            if (IndexResolverReplacer.isAllWithNoRemote(original)) {
                if (isTraceEnabled) {
                    IndexResolverReplacer.this.log.trace(Arrays.toString(original) + " is an ALL pattern without any remote indices");
                }
                this.resolveToLocalAll();
                return;
            }
            ArrayList<String> localRequestedPatterns = new ArrayList<String>(Arrays.asList(original));
            RemoteClusterService remoteClusterService = OpenSearchSecurityPlugin.GuiceHolder.getRemoteClusterService();
            if (remoteClusterService.isCrossClusterSearchEnabled() && enableCrossClusterResolution) {
                remoteIndices = new HashSet();
                Map remoteClusterIndices = OpenSearchSecurityPlugin.GuiceHolder.getRemoteClusterService().groupIndices(indicesOptions, original, idx -> IndexResolverReplacer.this.resolver.hasIndexAbstraction(idx, IndexResolverReplacer.this.clusterService.state()));
                Set<String> remoteClusters = remoteClusterIndices.keySet().stream().filter(k -> !"".equals(k)).collect(Collectors.toSet());
                for (String remoteCluster : remoteClusters) {
                    for (String remoteIndex : ((OriginalIndices)remoteClusterIndices.get(remoteCluster)).indices()) {
                        remoteIndices.add(RemoteClusterService.buildRemoteIndexName((String)remoteCluster, (String)remoteIndex));
                    }
                }
                Iterator iterator = localRequestedPatterns.iterator();
                while (iterator.hasNext()) {
                    String[] split = ((String)iterator.next()).split(String.valueOf(':'), 2);
                    WildcardMatcher matcher = WildcardMatcher.from(split[0]);
                    if (split.length <= 1 || !matcher.matchAny(remoteClusters)) continue;
                    iterator.remove();
                }
                if (isTraceEnabled) {
                    IndexResolverReplacer.this.log.trace("CCS is enabled, we found this local patterns " + localRequestedPatterns + " and this remote patterns: " + remoteIndices);
                }
            } else {
                remoteIndices = Collections.emptySet();
            }
            List matchingDataStreams = null;
            if (IndexResolverReplacer.isLocalAll(original)) {
                if (isTraceEnabled) {
                    IndexResolverReplacer.this.log.trace(Arrays.toString(original) + " is an LOCAL ALL pattern");
                }
                matchingAliases = Resolved.All_SET;
                matchingAllIndices = Resolved.All_SET;
            } else if (!remoteIndices.isEmpty() && localRequestedPatterns.isEmpty()) {
                if (isTraceEnabled) {
                    IndexResolverReplacer.this.log.trace(Arrays.toString(original) + " is an LOCAL EMPTY request");
                }
                matchingAllIndices = Collections.emptySet();
                matchingAliases = Collections.emptySet();
            } else {
                ClusterState state = IndexResolverReplacer.this.clusterService.state();
                Set dateResolvedLocalRequestedPatterns = localRequestedPatterns.stream().map(arg_0 -> ((IndexNameExpressionResolver)IndexResolverReplacer.this.resolver).resolveDateMathExpression(arg_0)).collect(Collectors.toSet());
                WildcardMatcher dateResolvedMatcher = WildcardMatcher.from(dateResolvedLocalRequestedPatterns);
                SortedMap lookup = state.metadata().getIndicesLookup();
                matchingAliases = lookup.entrySet().stream().filter(e -> ((IndexAbstraction)e.getValue()).getType() == IndexAbstraction.Type.ALIAS).map(Map.Entry::getKey).filter(dateResolvedMatcher).collect(Collectors.toSet());
                boolean isDebugEnabled = IndexResolverReplacer.this.log.isDebugEnabled();
                try {
                    matchingAllIndices = Arrays.asList(IndexResolverReplacer.this.resolver.concreteIndexNames(state, indicesOptions, localRequestedPatterns.toArray(new String[0])));
                    matchingDataStreams = IndexResolverReplacer.this.resolver.dataStreamNames(state, indicesOptions, localRequestedPatterns.toArray(new String[0]));
                    if (isDebugEnabled) {
                        IndexResolverReplacer.this.log.debug("Resolved pattern {} to indices: {} and data-streams: {}", localRequestedPatterns, matchingAllIndices, (Object)matchingDataStreams);
                    }
                }
                catch (IndexNotFoundException e1) {
                    if (isDebugEnabled) {
                        IndexResolverReplacer.this.log.debug("No such indices for pattern {}, use raw value", localRequestedPatterns);
                    }
                    matchingAllIndices = dateResolvedLocalRequestedPatterns;
                }
            }
            if (matchingDataStreams == null || matchingDataStreams.size() == 0) {
                matchingDataStreams = Arrays.asList(NOOP);
            }
            if (isTraceEnabled) {
                IndexResolverReplacer.this.log.trace("Resolved patterns {} for {} ({}) to [aliases {}, allIndices {}, dataStreams {}, originalRequested{}, remote indices {}]", (Object)original, (Object)name, (Object)this.name, matchingAliases, matchingAllIndices, matchingDataStreams, (Object)Arrays.toString(original), remoteIndices);
            }
            this.resolveTo((Iterable<String>)matchingAliases, (Iterable<String>)matchingAllIndices, matchingDataStreams, original, (Iterable<String>)remoteIndices);
        }

        private void resolveToLocalAll() {
            this.aliases.add((Object)"*");
            this.allIndices.add((Object)"*");
            this.originalRequested.add((Object)"*");
        }

        private void resolveTo(Iterable<String> matchingAliases, Iterable<String> matchingAllIndices, Iterable<String> matchingDataStreams, String[] original, Iterable<String> remoteIndices) {
            this.aliases.addAll(matchingAliases);
            this.allIndices.addAll(matchingAllIndices);
            this.allIndices.addAll(matchingDataStreams);
            this.originalRequested.add((Object[])original);
            this.remoteIndices.addAll(remoteIndices);
        }

        @Override
        public String[] provide(String[] original, Object localRequest, boolean supportsReplace) {
            boolean enableCrossClusterResolution;
            IndicesOptions indicesOptions = IndexResolverReplacer.this.indicesOptionsFrom(localRequest);
            if (this.alreadyResolved.add(new MultiKey((Object)indicesOptions, (Object)(enableCrossClusterResolution = localRequest instanceof FieldCapabilitiesRequest || localRequest instanceof SearchRequest || localRequest instanceof ResolveIndexAction.Request), (Object)(original != null ? new MultiKey((Object[])original, false) : null)))) {
                this.resolveIndexPatterns(localRequest.getClass().getSimpleName(), indicesOptions, enableCrossClusterResolution, original);
            }
            return IndicesProvider.NOOP;
        }

        Resolved resolved(IndicesOptions indicesOptions) {
            Resolved resolved;
            Resolved resolved2 = resolved = this.alreadyResolved.isEmpty() ? Resolved._LOCAL_ALL : new Resolved((ImmutableSet<String>)this.aliases.build(), (ImmutableSet<String>)this.allIndices.build(), (ImmutableSet<String>)this.originalRequested.build(), (ImmutableSet<String>)this.remoteIndices.build(), indicesOptions);
            if (IndexResolverReplacer.this.log.isTraceEnabled()) {
                IndexResolverReplacer.this.log.trace("Finally resolved for {}: {}", (Object)this.name, (Object)resolved);
            }
            return resolved;
        }
    }

    public static final class Resolved {
        private static final String ANY = "*";
        private static final ImmutableSet<String> All_SET = ImmutableSet.of((Object)"*");
        private static final Set<String> types = All_SET;
        public static final Resolved _LOCAL_ALL = new Resolved(All_SET, All_SET, All_SET, (ImmutableSet<String>)ImmutableSet.of(), SearchRequest.DEFAULT_INDICES_OPTIONS);
        private final Set<String> aliases;
        private final Set<String> allIndices;
        private final Set<String> originalRequested;
        private final Set<String> remoteIndices;
        private final boolean isLocalAll;
        private final IndicesOptions indicesOptions;

        private Resolved(ImmutableSet<String> aliases, ImmutableSet<String> allIndices, ImmutableSet<String> originalRequested, ImmutableSet<String> remoteIndices, IndicesOptions indicesOptions) {
            this.aliases = aliases;
            this.allIndices = allIndices;
            this.originalRequested = originalRequested;
            this.remoteIndices = remoteIndices;
            this.isLocalAll = IndexResolverReplacer.isLocalAll((String[])originalRequested.toArray((Object[])new String[0])) || aliases.contains((Object)ANY) && allIndices.contains((Object)ANY);
            this.indicesOptions = indicesOptions;
        }

        public boolean isLocalAll() {
            return this.isLocalAll;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public Set<String> getAllIndices() {
            return this.allIndices;
        }

        public Set<String> getAllIndicesResolved(ClusterService clusterService, IndexNameExpressionResolver resolver) {
            if (this.isLocalAll) {
                return new HashSet<String>(Arrays.asList(resolver.concreteIndexNames(clusterService.state(), this.indicesOptions, new String[]{ANY})));
            }
            return this.allIndices;
        }

        public boolean isAllIndicesEmpty() {
            return this.allIndices.isEmpty();
        }

        public Set<String> getTypes() {
            return types;
        }

        public Set<String> getRemoteIndices() {
            return this.remoteIndices;
        }

        public String toString() {
            return "Resolved [aliases=" + this.aliases + ", allIndices=" + this.allIndices + ", types=" + types + ", originalRequested=" + this.originalRequested + ", remoteIndices=" + this.remoteIndices + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
            result = 31 * result + (this.allIndices == null ? 0 : this.allIndices.hashCode());
            result = 31 * result + (this.originalRequested == null ? 0 : this.originalRequested.hashCode());
            result = 31 * result + (this.remoteIndices == null ? 0 : this.remoteIndices.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resolved other = (Resolved)obj;
            if (this.aliases == null ? other.aliases != null : !this.aliases.equals(other.aliases)) {
                return false;
            }
            if (this.allIndices == null ? other.allIndices != null : !this.allIndices.equals(other.allIndices)) {
                return false;
            }
            if (this.originalRequested == null ? other.originalRequested != null : !this.originalRequested.equals(other.originalRequested)) {
                return false;
            }
            return !(this.remoteIndices == null ? other.remoteIndices != null : !this.remoteIndices.equals(other.remoteIndices));
        }
    }
}

