/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import com.google.common.base.Predicates;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.user.AuthCredentials;

public class HTTPProxyAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Settings settings;
    private final Pattern rolesSeparator;

    public HTTPProxyAuthenticator(Settings settings, Path configPath) {
        this.settings = settings;
        this.rolesSeparator = Pattern.compile(settings.get("roles_separator", ","));
    }

    @Override
    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) {
        if (context.getTransient("_opendistro_security_xff_done") != Boolean.TRUE) {
            throw new OpenSearchSecurityException("xff not done", new Object[0]);
        }
        String userHeader = this.settings.get("user_header");
        String rolesHeader = this.settings.get("roles_header");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Headers {}", (Object)request.getHeaders());
            this.log.debug("UserHeader {}, value {}", (Object)userHeader, userHeader == null ? null : request.header(userHeader));
            this.log.debug("RolesHeader {}, value {}", (Object)rolesHeader, rolesHeader == null ? null : request.header(rolesHeader));
        }
        if (!Strings.isNullOrEmpty((String)userHeader) && !Strings.isNullOrEmpty((String)request.header(userHeader))) {
            String[] backendRoles = null;
            if (!Strings.isNullOrEmpty((String)rolesHeader) && !Strings.isNullOrEmpty((String)request.header(rolesHeader))) {
                backendRoles = (String[])this.rolesSeparator.splitAsStream(request.header(rolesHeader)).map(String::trim).filter((Predicate<String>)Predicates.not(String::isEmpty)).toArray(String[]::new);
            }
            return new AuthCredentials(request.header(userHeader), backendRoles).markComplete();
        }
        this.log.trace("No '{}' header, send 401", (Object)userHeader);
        return null;
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        return false;
    }

    @Override
    public String getType() {
        return "proxy";
    }
}

