/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.SimpleQueryStringBuilder;
import org.opensearch.index.query.SimpleQueryStringFlag;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

public class SimpleQueryStringQuery
extends RelevanceQuery<SimpleQueryStringBuilder> {
    public SimpleQueryStringQuery() {
        super(ImmutableMap.builder().put((Object)"analyze_wildcard", (b, v) -> b.analyzeWildcard(Boolean.parseBoolean(v.stringValue()))).put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(Boolean.parseBoolean(v.stringValue()))).put((Object)"boost", (b, v) -> (SimpleQueryStringBuilder)b.boost(Float.parseFloat(v.stringValue()))).put((Object)"default_operator", (b, v) -> b.defaultOperator(Operator.fromString((String)v.stringValue()))).put((Object)"flags", (b, v) -> b.flags((SimpleQueryStringFlag[])Arrays.stream(v.stringValue().split("\\|")).map(SimpleQueryStringFlag::valueOf).toArray(SimpleQueryStringFlag[]::new))).put((Object)"fuzzy_max_expansions", (b, v) -> b.fuzzyMaxExpansions(Integer.parseInt(v.stringValue()))).put((Object)"fuzzy_prefix_length", (b, v) -> b.fuzzyPrefixLength(Integer.parseInt(v.stringValue()))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(Boolean.parseBoolean(v.stringValue()))).put((Object)"lenient", (b, v) -> b.lenient(Boolean.parseBoolean(v.stringValue()))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"quote_field_suffix", (b, v) -> b.quoteFieldSuffix(v.stringValue())).build());
    }

    @Override
    public QueryBuilder build(FunctionExpression func) {
        if (func.getArguments().size() < 2) {
            throw new SemanticCheckException("'simple_query_string' must have at least two arguments");
        }
        Iterator iterator = func.getArguments().iterator();
        NamedArgumentExpression fields = (NamedArgumentExpression)iterator.next();
        NamedArgumentExpression query = (NamedArgumentExpression)iterator.next();
        ImmutableMap fieldsAndWeights = (ImmutableMap)fields.getValue().valueOf(null).tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue()));
        SimpleQueryStringBuilder queryBuilder = this.createQueryBuilder(null, query.getValue().valueOf(null).stringValue()).fields((Map)fieldsAndWeights);
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = (NamedArgumentExpression)iterator.next();
            if (!this.queryBuildActions.containsKey(arg.getArgName())) {
                throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", arg.getArgName(), queryBuilder.getWriteableName()));
            }
            Objects.requireNonNull((RelevanceQuery.QueryBuilderStep)this.queryBuildActions.get(arg.getArgName())).apply(queryBuilder, arg.getValue().valueOf(null));
        }
        return queryBuilder;
    }

    @Override
    protected SimpleQueryStringBuilder createQueryBuilder(String field, String query) {
        return QueryBuilders.simpleQueryStringQuery((String)query);
    }
}

