/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public abstract class RelevanceQuery<T extends QueryBuilder>
extends LuceneQuery {
    protected Map<String, QueryBuilderStep<T>> queryBuildActions;

    protected RelevanceQuery(Map<String, QueryBuilderStep<T>> actionMap) {
        this.queryBuildActions = actionMap;
    }

    @Override
    public QueryBuilder build(FunctionExpression func) {
        List arguments = func.getArguments();
        if (arguments.size() < 2) {
            String queryName = this.createQueryBuilder("dummy_field", "").getWriteableName();
            throw new SyntaxCheckException(String.format("%s requires at least two parameters", queryName));
        }
        NamedArgumentExpression field = (NamedArgumentExpression)arguments.get(0);
        NamedArgumentExpression query = (NamedArgumentExpression)arguments.get(1);
        T queryBuilder = this.createQueryBuilder(field.getValue().valueOf(null).stringValue(), query.getValue().valueOf(null).stringValue());
        ListIterator iterator = arguments.listIterator(2);
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = (NamedArgumentExpression)iterator.next();
            if (!this.queryBuildActions.containsKey(arg.getArgName())) {
                throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", arg.getArgName(), queryBuilder.getWriteableName()));
            }
            Objects.requireNonNull(this.queryBuildActions.get(arg.getArgName())).apply(queryBuilder, arg.getValue().valueOf(null));
        }
        return queryBuilder;
    }

    protected abstract T createQueryBuilder(String var1, String var2);

    public static interface QueryBuilderStep<T extends QueryBuilder>
    extends BiFunction<T, ExprValue, T> {
    }
}

